/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.joni;

import io.airlift.joni.Analyser;
import io.airlift.joni.BitStatus;
import io.airlift.joni.CodeRangeBuffer;
import io.airlift.joni.Compiler;
import io.airlift.joni.MatcherFactory;
import io.airlift.joni.Option;
import io.airlift.joni.ast.AnchorNode;
import io.airlift.joni.ast.BackRefNode;
import io.airlift.joni.ast.CClassNode;
import io.airlift.joni.ast.CTypeNode;
import io.airlift.joni.ast.CallNode;
import io.airlift.joni.ast.ConsAltNode;
import io.airlift.joni.ast.EncloseNode;
import io.airlift.joni.ast.Node;
import io.airlift.joni.ast.QuantifierNode;
import io.airlift.joni.ast.StringNode;

final class ArrayCompiler
extends Compiler {
    private int[] code;
    private int codeLength;
    private byte[][] templates;
    private int templateNum;
    private static final int REPEAT_RANGE_ALLOC = 8;
    private static final int QUANTIFIER_EXPAND_LIMIT_SIZE = 50;

    ArrayCompiler(Analyser analyser) {
        super(analyser);
    }

    protected final void prepare() {
        int codeSize = 8;
        this.code = new int[codeSize];
        this.codeLength = 0;
    }

    protected final void finish() {
        this.addOpcode(1);
        this.addOpcode(0);
        this.regex.code = this.code;
        this.regex.codeLength = this.codeLength;
        this.regex.templates = this.templates;
        this.regex.templateNum = this.templateNum;
        this.regex.factory = MatcherFactory.DEFAULT;
        if (this.analyser.env.unsetAddrList != null) {
            this.analyser.env.unsetAddrList.fix(this.regex);
            this.analyser.env.unsetAddrList = null;
        }
    }

    protected void compileAltNode(ConsAltNode node) {
        ConsAltNode aln = node;
        int len = 0;
        do {
            len += this.compileLengthTree(aln.car);
            if (aln.cdr == null) continue;
            len += 4;
        } while ((aln = aln.cdr) != null);
        int pos = this.codeLength + len;
        aln = node;
        do {
            len = this.compileLengthTree(aln.car);
            if (aln.cdr != null) {
                this.addOpcodeRelAddr(63, len + 2);
            }
            this.compileTree(aln.car);
            if (aln.cdr == null) continue;
            len = pos - (this.codeLength + 2);
            this.addOpcodeRelAddr(62, len);
        } while ((aln = aln.cdr) != null);
    }

    private boolean isNeedStrLenOpExact(int op) {
        return op == 7 || op == 11 || op == 12 || op == 13 || op == 15 || op == 114;
    }

    private boolean opTemplated(int op) {
        return this.isNeedStrLenOpExact(op);
    }

    private int selectStrOpcode(int mbLength, int strLength, boolean ignoreCase) {
        int op;
        if (ignoreCase) {
            switch (strLength) {
                case 1: {
                    op = this.enc.toLowerCaseTable() != null ? 113 : 14;
                    break;
                }
                default: {
                    op = this.enc.toLowerCaseTable() != null ? 114 : 15;
                    break;
                }
            }
        } else {
            block3 : switch (mbLength) {
                case 1: {
                    switch (strLength) {
                        case 1: {
                            op = 2;
                            break block3;
                        }
                        case 2: {
                            op = 3;
                            break block3;
                        }
                        case 3: {
                            op = 4;
                            break block3;
                        }
                        case 4: {
                            op = 5;
                            break block3;
                        }
                        case 5: {
                            op = 6;
                            break block3;
                        }
                    }
                    op = 7;
                    break;
                }
                case 2: {
                    switch (strLength) {
                        case 1: {
                            op = 8;
                            break block3;
                        }
                        case 2: {
                            op = 9;
                            break block3;
                        }
                        case 3: {
                            op = 10;
                            break block3;
                        }
                    }
                    op = 11;
                    break;
                }
                case 3: {
                    op = 12;
                    break;
                }
                default: {
                    op = 13;
                }
            }
        }
        return op;
    }

    private void compileTreeEmptyCheck(Node node, int emptyInfo) {
        int savedNumNullCheck = this.regex.numNullCheck;
        if (emptyInfo != 0) {
            this.addOpcode(73);
            this.addMemNum(this.regex.numNullCheck);
            ++this.regex.numNullCheck;
        }
        this.compileTree(node);
        if (emptyInfo != 0) {
            switch (emptyInfo) {
                case 1: {
                    this.addOpcode(74);
                    break;
                }
                case 2: {
                    this.addOpcode(75);
                    break;
                }
                case 3: {
                    this.addOpcode(76);
                }
            }
            this.addMemNum(savedNumNullCheck);
        }
    }

    private int addCompileStringlength(byte[] bytes, int p, int mbLength, int strLength, boolean ignoreCase) {
        int op = this.selectStrOpcode(mbLength, strLength, ignoreCase);
        int len = 1;
        if (this.opTemplated(op)) {
            len += 3;
        } else {
            if (this.isNeedStrLenOpExact(op)) {
                ++len;
            }
            len += mbLength * strLength;
        }
        if (op == 13) {
            ++len;
        }
        return len;
    }

    protected final void addCompileString(byte[] bytes, int p, int mbLength, int strLength, boolean ignoreCase) {
        int op = this.selectStrOpcode(mbLength, strLength, ignoreCase);
        this.addOpcode(op);
        if (op == 13) {
            this.addLength(mbLength);
        }
        if (this.isNeedStrLenOpExact(op)) {
            if (op == 15 || op == 114) {
                this.addLength(mbLength * strLength);
            } else {
                this.addLength(strLength);
            }
        }
        if (this.opTemplated(op)) {
            this.addInt(this.templateNum);
            this.addInt(p);
            this.addTemplate(bytes);
        } else {
            this.addBytes(bytes, p, mbLength * strLength);
        }
    }

    private int compileLengthStringNode(Node node) {
        int prev;
        StringNode sn = (StringNode)node;
        if (sn.length() <= 0) {
            return 0;
        }
        boolean ambig = sn.isAmbig();
        int p = prev = sn.p;
        int end = sn.end;
        byte[] bytes = sn.bytes;
        int prevLen = this.enc.length(bytes, p, end);
        p += prevLen;
        int slen = 1;
        int rlen = 0;
        while (p < end) {
            int len = this.enc.length(bytes, p, end);
            if (len == prevLen) {
                ++slen;
            } else {
                int r = this.addCompileStringlength(bytes, prev, prevLen, slen, ambig);
                rlen += r;
                prev = p;
                slen = 1;
                prevLen = len;
            }
            p += len;
        }
        int r = this.addCompileStringlength(bytes, prev, prevLen, slen, ambig);
        return rlen += r;
    }

    private int compileLengthStringRawNode(StringNode sn) {
        if (sn.length() <= 0) {
            return 0;
        }
        return this.addCompileStringlength(sn.bytes, sn.p, 1, sn.length(), false);
    }

    private void addMultiByteCClass(CodeRangeBuffer mbuf) {
        this.addLength(mbuf.used);
        this.addInts(mbuf.p, mbuf.used);
    }

    private int compileLengthCClassNode(CClassNode cc) {
        int len;
        if (cc.isShare()) {
            return 2;
        }
        if (cc.mbuf == null) {
            len = 9;
        } else {
            len = this.enc.minLength() > 1 || cc.bs.isEmpty() ? 1 : 9;
            len += 1 + cc.mbuf.used;
        }
        return len;
    }

    protected void compileCClassNode(CClassNode cc) {
        if (cc.isShare()) {
            this.addOpcode(22);
            this.addPointer(cc);
            return;
        }
        if (cc.mbuf == null) {
            if (cc.isNot()) {
                this.addOpcode(this.enc.isSingleByte() ? 105 : 19);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 104 : 16);
            }
            this.addInts(cc.bs.bits, 8);
        } else if (this.enc.minLength() > 1 || cc.bs.isEmpty()) {
            if (cc.isNot()) {
                this.addOpcode(20);
            } else {
                this.addOpcode(17);
            }
            this.addMultiByteCClass(cc.mbuf);
        } else {
            if (cc.isNot()) {
                this.addOpcode(21);
            } else {
                this.addOpcode(18);
            }
            this.addInts(cc.bs.bits, 8);
            this.addMultiByteCClass(cc.mbuf);
        }
    }

    protected void compileCTypeNode(CTypeNode node) {
        int op;
        CTypeNode cn = node;
        switch (cn.ctype) {
            case 12: {
                if (cn.not) {
                    op = this.enc.isSingleByte() ? 107 : 30;
                    break;
                }
                op = this.enc.isSingleByte() ? 106 : 29;
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
                return;
            }
        }
        this.addOpcode(op);
    }

    protected void compileAnyCharNode() {
        if (Option.isMultiline(this.regex.options)) {
            this.addOpcode(this.enc.isSingleByte() ? 97 : 24);
        } else {
            this.addOpcode(this.enc.isSingleByte() ? 96 : 23);
        }
    }

    protected void compileCallNode(CallNode node) {
        this.addOpcode(86);
        node.unsetAddrList.add(this.codeLength, node.target);
        this.addAbsAddr(0);
    }

    protected void compileBackrefNode(BackRefNode node) {
        BackRefNode br = node;
        if (br.isNestLevel()) {
            this.addOpcode(53);
            this.addOption(this.regex.options & 1);
            this.addLength(br.nestLevel);
            this.addLength(br.backNum);
            for (int i = br.backNum - 1; i >= 0; --i) {
                this.addMemNum(br.back[i]);
            }
            return;
        }
        if (br.backNum == 1) {
            if (Option.isIgnoreCase(this.regex.options)) {
                this.addOpcode(50);
                this.addMemNum(br.back[0]);
            } else {
                switch (br.back[0]) {
                    case 1: {
                        this.addOpcode(47);
                        break;
                    }
                    case 2: {
                        this.addOpcode(48);
                        break;
                    }
                    default: {
                        this.addOpcode(49);
                        this.addOpcode(br.back[0]);
                        break;
                    }
                }
            }
        } else {
            if (Option.isIgnoreCase(this.regex.options)) {
                this.addOpcode(52);
            } else {
                this.addOpcode(51);
            }
            this.addLength(br.backNum);
            for (int i = br.backNum - 1; i >= 0; --i) {
                this.addMemNum(br.back[i]);
            }
        }
    }

    private void entryRepeatRange(int id, int lower, int upper) {
        if (this.regex.repeatRangeLo == null) {
            this.regex.repeatRangeLo = new int[8];
            this.regex.repeatRangeHi = new int[8];
        } else if (id >= this.regex.repeatRangeLo.length) {
            int[] tmp = new int[this.regex.repeatRangeLo.length + 8];
            System.arraycopy(this.regex.repeatRangeLo, 0, tmp, 0, this.regex.repeatRangeLo.length);
            this.regex.repeatRangeLo = tmp;
            tmp = new int[this.regex.repeatRangeHi.length + 8];
            System.arraycopy(this.regex.repeatRangeHi, 0, tmp, 0, this.regex.repeatRangeHi.length);
            this.regex.repeatRangeHi = tmp;
        }
        this.regex.repeatRangeLo[id] = lower;
        this.regex.repeatRangeHi[id] = QuantifierNode.isRepeatInfinite(upper) ? Integer.MAX_VALUE : upper;
    }

    private void compileRangeRepeatNode(QuantifierNode qn, int targetLen, int emptyInfo) {
        int numRepeat = this.regex.numRepeat;
        this.addOpcode(qn.greedy ? 67 : 68);
        this.addMemNum(numRepeat);
        ++this.regex.numRepeat;
        this.addRelAddr(targetLen + 2);
        this.entryRepeatRange(numRepeat, qn.lower, qn.upper);
        this.compileTreeEmptyCheck(qn.target, emptyInfo);
        if (this.regex.numCall > 0 || qn.isInRepeat()) {
            this.addOpcode(qn.greedy ? 71 : 72);
        } else {
            this.addOpcode(qn.greedy ? 69 : 70);
        }
        this.addMemNum(numRepeat);
    }

    private static boolean cknOn(int ckn) {
        return ckn > 0;
    }

    private int compileCECLengthQuantifierNode(QuantifierNode qn) {
        int len;
        int cklen;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        int ckn = this.regex.numCombExpCheck > 0 ? qn.combExpCheckNum : 0;
        int n = cklen = ArrayCompiler.cknOn(ckn) ? 1 : 0;
        if (qn.target.getType() == 3 && qn.greedy && infinite) {
            if (qn.nextHeadExact != null && !ArrayCompiler.cknOn(ckn)) {
                return 2 + tlen * qn.lower + cklen;
            }
            return 1 + tlen * qn.lower + cklen;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && qn.lower <= 1) {
            if (qn.greedy) {
                len = qn.lower == 1 ? 2 : 0;
                len += 2 + cklen + modTLen + 2;
            } else {
                len = qn.lower == 0 ? 2 : 0;
                len += modTLen + 2 + cklen;
            }
        } else if (qn.upper == 0) {
            len = qn.isRefered ? 2 + tlen : 0;
        } else if (qn.upper == 1 && qn.greedy) {
            len = qn.lower == 0 ? (ArrayCompiler.cknOn(ckn) ? 3 + tlen : 2 + tlen) : tlen;
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            len = 2 + cklen + 2 + tlen;
        } else {
            len = 2 + modTLen + 1 + 1 + 1;
            if (ArrayCompiler.cknOn(ckn)) {
                len += 2;
            }
        }
        return len;
    }

    protected void compileCECQuantifierNode(QuantifierNode qn) {
        int ckn;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        int n = ckn = this.regex.numCombExpCheck > 0 ? qn.combExpCheckNum : 0;
        if (qn.isAnyCharStar()) {
            this.compileTreeNTimes(qn.target, qn.lower);
            if (qn.nextHeadExact != null && !ArrayCompiler.cknOn(ckn)) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(this.enc.isSingleByte() ? 101 : 28);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 100 : 27);
                }
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addStateCheckNum(ckn);
                }
                StringNode sn = (StringNode)qn.nextHeadExact;
                this.addBytes(sn.bytes, sn.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(this.enc.isSingleByte() ? 103 : 93);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 99 : 26);
                }
            } else if (ArrayCompiler.cknOn(ckn)) {
                this.addOpcode(this.enc.isSingleByte() ? 102 : 92);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 98 : 25);
            }
            if (ArrayCompiler.cknOn(ckn)) {
                this.addStateCheckNum(ckn);
            }
            return;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && qn.lower <= 1) {
            if (qn.greedy) {
                if (qn.lower == 1) {
                    this.addOpcodeRelAddr(62, ArrayCompiler.cknOn(ckn) ? 3 : 2);
                }
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(89);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(modTLen + 2);
                } else {
                    this.addOpcodeRelAddr(63, modTLen + 2);
                }
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                this.addOpcodeRelAddr(62, -(modTLen + 2 + (ArrayCompiler.cknOn(ckn) ? 3 : 2)));
            } else {
                if (qn.lower == 0) {
                    this.addOpcodeRelAddr(62, modTLen);
                }
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(90);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(-(modTLen + 3));
                } else {
                    this.addOpcodeRelAddr(63, -(modTLen + 2));
                }
            }
        } else if (qn.upper == 0) {
            if (qn.isRefered) {
                this.addOpcodeRelAddr(62, tlen);
                this.compileTree(qn.target);
            }
        } else if (qn.upper == 1 && qn.greedy) {
            if (qn.lower == 0) {
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(89);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(tlen);
                } else {
                    this.addOpcodeRelAddr(63, tlen);
                }
            }
            this.compileTree(qn.target);
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            if (ArrayCompiler.cknOn(ckn)) {
                this.addOpcode(89);
                this.addStateCheckNum(ckn);
                this.addRelAddr(2);
            } else {
                this.addOpcodeRelAddr(63, 2);
            }
            this.addOpcodeRelAddr(62, tlen);
            this.compileTree(qn.target);
        } else {
            this.compileRangeRepeatNode(qn, modTLen, emptyInfo);
            if (ArrayCompiler.cknOn(ckn)) {
                this.addOpcode(91);
                this.addStateCheckNum(ckn);
            }
        }
    }

    private int compileNonCECLengthQuantifierNode(QuantifierNode qn) {
        int len;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        if (qn.target.getType() == 3 && qn.greedy && infinite) {
            if (qn.nextHeadExact != null) {
                return 2 + tlen * qn.lower;
            }
            return 1 + tlen * qn.lower;
        }
        int modTLen = 0;
        modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && (qn.lower <= 1 || tlen * qn.lower <= 50)) {
            len = qn.lower == 1 && tlen > 50 ? 2 : tlen * qn.lower;
            len = qn.greedy ? (qn.headExact != null ? (len += 3 + modTLen + 2) : (qn.nextHeadExact != null ? (len += 3 + modTLen + 2) : (len += 2 + modTLen + 2))) : (len += 2 + modTLen + 2);
        } else if (qn.upper == 0 && qn.isRefered) {
            len = 2 + tlen;
        } else if (!infinite && qn.greedy && (qn.upper == 1 || (tlen + 2) * qn.upper <= 50)) {
            len = tlen * qn.lower;
            len += (2 + tlen) * (qn.upper - qn.lower);
        } else {
            len = !qn.greedy && qn.upper == 1 && qn.lower == 0 ? 4 + tlen : 2 + modTLen + 1 + 1 + 1;
        }
        return len;
    }

    protected void compileNonCECQuantifierNode(QuantifierNode qn) {
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        if (qn.isAnyCharStar()) {
            this.compileTreeNTimes(qn.target, qn.lower);
            if (qn.nextHeadExact != null) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(this.enc.isSingleByte() ? 101 : 28);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 100 : 27);
                }
                StringNode sn = (StringNode)qn.nextHeadExact;
                this.addBytes(sn.bytes, sn.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                this.addOpcode(this.enc.isSingleByte() ? 99 : 26);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 98 : 25);
            }
            return;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && (qn.lower <= 1 || tlen * qn.lower <= 50)) {
            if (qn.lower == 1 && tlen > 50) {
                if (qn.greedy) {
                    if (qn.headExact != null) {
                        this.addOpcodeRelAddr(62, 3);
                    } else if (qn.nextHeadExact != null) {
                        this.addOpcodeRelAddr(62, 3);
                    } else {
                        this.addOpcodeRelAddr(62, 2);
                    }
                } else {
                    this.addOpcodeRelAddr(62, 2);
                }
            } else {
                this.compileTreeNTimes(qn.target, qn.lower);
            }
            if (qn.greedy) {
                if (qn.headExact != null) {
                    this.addOpcodeRelAddr(65, modTLen + 2);
                    StringNode sn = (StringNode)qn.headExact;
                    this.addBytes(sn.bytes, sn.p, 1);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(62, -(modTLen + 2 + 3));
                } else if (qn.nextHeadExact != null) {
                    this.addOpcodeRelAddr(66, modTLen + 2);
                    StringNode sn = (StringNode)qn.nextHeadExact;
                    this.addBytes(sn.bytes, sn.p, 1);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(62, -(modTLen + 2 + 3));
                } else {
                    this.addOpcodeRelAddr(63, modTLen + 2);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(62, -(modTLen + 2 + 2));
                }
            } else {
                this.addOpcodeRelAddr(62, modTLen);
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                this.addOpcodeRelAddr(63, -(modTLen + 2));
            }
        } else if (qn.upper == 0 && qn.isRefered) {
            this.addOpcodeRelAddr(62, tlen);
            this.compileTree(qn.target);
        } else if (!infinite && qn.greedy && (qn.upper == 1 || (tlen + 2) * qn.upper <= 50)) {
            int n = qn.upper - qn.lower;
            this.compileTreeNTimes(qn.target, qn.lower);
            for (int i = 0; i < n; ++i) {
                this.addOpcodeRelAddr(63, (n - i) * tlen + (n - i - 1) * 2);
                this.compileTree(qn.target);
            }
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            this.addOpcodeRelAddr(63, 2);
            this.addOpcodeRelAddr(62, tlen);
            this.compileTree(qn.target);
        } else {
            this.compileRangeRepeatNode(qn, modTLen, emptyInfo);
        }
    }

    private int compileLengthOptionNode(EncloseNode node) {
        int prev = this.regex.options;
        this.regex.options = node.option;
        int tlen = this.compileLengthTree(node.target);
        this.regex.options = prev;
        if (Option.isDynamic(prev ^ node.option)) {
            return 5 + tlen + 2;
        }
        return tlen;
    }

    protected void compileOptionNode(EncloseNode node) {
        int prev = this.regex.options;
        if (Option.isDynamic(prev ^ node.option)) {
            this.addOpcodeOption(94, node.option);
            this.addOpcodeOption(95, prev);
            this.addOpcode(61);
        }
        this.regex.options = node.option;
        this.compileTree(node.target);
        this.regex.options = prev;
        if (Option.isDynamic(prev ^ node.option)) {
            this.addOpcodeOption(95, prev);
        }
    }

    private int compileLengthEncloseNode(EncloseNode node) {
        int len;
        if (node.isOption()) {
            return this.compileLengthOptionNode(node);
        }
        int tlen = node.target != null ? this.compileLengthTree(node.target) : 0;
        switch (node.type) {
            case 1: {
                if (node.isCalled()) {
                    len = 2 + tlen + 2 + 2 + 1;
                    if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                        len += node.isRecursion() ? 2 : 2;
                        break;
                    }
                    len += node.isRecursion() ? 2 : 2;
                    break;
                }
                len = BitStatus.bsAt(this.regex.btMemStart, node.regNum) ? 2 : 2;
                len += tlen + (BitStatus.bsAt(this.regex.btMemEnd, node.regNum) ? 2 : 2);
                break;
            }
            case 4: {
                if (node.isStopBtSimpleRepeat()) {
                    QuantifierNode qn = (QuantifierNode)node.target;
                    tlen = this.compileLengthTree(qn.target);
                    len = tlen * qn.lower + 2 + tlen + 1 + 2;
                    break;
                }
                len = 1 + tlen + 1;
                break;
            }
            case 8: {
                len = 3;
                if (node.target.getType() == 9) {
                    ConsAltNode x = (ConsAltNode)node.target;
                    tlen = this.compileLengthTree(x.car);
                    len += tlen + 2;
                    if (x.cdr == null) {
                        this.newInternalException("internal parser error (bug)");
                    }
                    x = x.cdr;
                    tlen = this.compileLengthTree(x.car);
                    len += tlen;
                    if (x.cdr == null) break;
                    this.newSyntaxException("invalid conditional pattern");
                    break;
                }
                this.newInternalException("internal parser error (bug)");
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
                return 0;
            }
        }
        return len;
    }

    protected void compileEncloseNode(EncloseNode node) {
        switch (node.type) {
            case 1: {
                if (node.isCalled()) {
                    this.addOpcode(86);
                    node.callAddr = this.codeLength + 1 + 2;
                    node.setAddrFixed();
                    this.addAbsAddr(node.callAddr);
                    int len = this.compileLengthTree(node.target);
                    len += 3;
                    len = BitStatus.bsAt(this.regex.btMemEnd, node.regNum) ? (len += node.isRecursion() ? 2 : 2) : (len += node.isRecursion() ? 2 : 2);
                    this.addOpcodeRelAddr(62, len);
                }
                if (BitStatus.bsAt(this.regex.btMemStart, node.regNum)) {
                    this.addOpcode(55);
                } else {
                    this.addOpcode(54);
                }
                this.addMemNum(node.regNum);
                this.compileTree(node.target);
                if (node.isCalled()) {
                    if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                        this.addOpcode(node.isRecursion() ? 57 : 56);
                    } else {
                        this.addOpcode(node.isRecursion() ? 59 : 58);
                    }
                    this.addMemNum(node.regNum);
                    this.addOpcode(87);
                    break;
                }
                if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                    this.addOpcode(56);
                } else {
                    this.addOpcode(58);
                }
                this.addMemNum(node.regNum);
                break;
            }
            case 4: {
                if (node.isStopBtSimpleRepeat()) {
                    QuantifierNode qn = (QuantifierNode)node.target;
                    this.compileTreeNTimes(qn.target, qn.lower);
                    int len = this.compileLengthTree(qn.target);
                    this.addOpcodeRelAddr(63, len + 1 + 2);
                    this.compileTree(qn.target);
                    this.addOpcode(64);
                    this.addOpcodeRelAddr(62, -(2 + len + 1 + 2));
                    break;
                }
                this.addOpcode(81);
                this.compileTree(node.target);
                this.addOpcode(82);
                break;
            }
            case 8: {
                this.addOpcode(88);
                this.addMemNum(node.regNum);
                if (node.target.getType() == 9) {
                    ConsAltNode x = (ConsAltNode)node.target;
                    int len = this.compileLengthTree(x.car);
                    if (x.cdr == null) {
                        this.newInternalException("internal parser error (bug)");
                    }
                    x = x.cdr;
                    int len2 = this.compileLengthTree(x.car);
                    if (x.cdr != null) {
                        this.newSyntaxException("invalid conditional pattern");
                    }
                    x = (ConsAltNode)node.target;
                    this.addRelAddr(len + 2);
                    this.compileTree(x.car);
                    this.addOpcodeRelAddr(62, len2);
                    x = x.cdr;
                    this.compileTree(x.car);
                    break;
                }
                this.newInternalException("internal parser error (bug)");
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthAnchorNode(AnchorNode node) {
        int len;
        int tlen = node.target != null ? this.compileLengthTree(node.target) : 0;
        switch (node.type) {
            case 1024: {
                len = 1 + tlen + 1;
                break;
            }
            case 2048: {
                len = 2 + tlen + 1;
                break;
            }
            case 4096: {
                len = 2 + tlen;
                break;
            }
            case 8192: {
                len = 3 + tlen + 1;
                break;
            }
            default: {
                len = 1;
            }
        }
        return len;
    }

    protected void compileAnchorNode(AnchorNode node) {
        switch (node.type) {
            case 1: {
                this.addOpcode(41);
                break;
            }
            case 8: {
                this.addOpcode(42);
                break;
            }
            case 2: {
                this.addOpcode(43);
                break;
            }
            case 32: {
                this.addOpcode(44);
                break;
            }
            case 16: {
                this.addOpcode(45);
                break;
            }
            case 4: {
                this.addOpcode(46);
                break;
            }
            case 64: {
                this.addOpcode(this.enc.isSingleByte() ? 108 : 31);
                break;
            }
            case 128: {
                this.addOpcode(this.enc.isSingleByte() ? 109 : 32);
                break;
            }
            case 256: {
                this.addOpcode(this.enc.isSingleByte() ? 110 : 33);
                break;
            }
            case 512: {
                this.addOpcode(this.enc.isSingleByte() ? 111 : 34);
                break;
            }
            case 1024: {
                this.addOpcode(77);
                this.compileTree(node.target);
                this.addOpcode(78);
                break;
            }
            case 2048: {
                int len = this.compileLengthTree(node.target);
                this.addOpcodeRelAddr(79, len + 1);
                this.compileTree(node.target);
                this.addOpcode(80);
                break;
            }
            case 4096: {
                int n;
                this.addOpcode(this.enc.isSingleByte() ? 112 : 83);
                if (node.charLength < 0) {
                    n = this.analyser.getCharLengthTree(node.target);
                    if (this.analyser.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = node.charLength;
                }
                this.addLength(n);
                this.compileTree(node.target);
                break;
            }
            case 8192: {
                int n;
                int len = this.compileLengthTree(node.target);
                this.addOpcodeRelAddr(84, len + 1);
                if (node.charLength < 0) {
                    n = this.analyser.getCharLengthTree(node.target);
                    if (this.analyser.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = node.charLength;
                }
                this.addLength(n);
                this.compileTree(node.target);
                this.addOpcode(85);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthTree(Node node) {
        int len = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode lin = (ConsAltNode)node;
                do {
                    len += this.compileLengthTree(lin.car);
                } while ((lin = lin.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode aln = (ConsAltNode)node;
                int n = 0;
                do {
                    len += this.compileLengthTree(aln.car);
                    ++n;
                } while ((aln = aln.cdr) != null);
                len += 4 * (n - 1);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.isRaw()) {
                    len = this.compileLengthStringRawNode(sn);
                    break;
                }
                len = this.compileLengthStringNode(sn);
                break;
            }
            case 1: {
                len = this.compileLengthCClassNode((CClassNode)node);
                break;
            }
            case 2: 
            case 3: {
                len = 1;
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isNestLevel()) {
                    len = 4 + 1 * br.backNum;
                    break;
                }
                if (br.backNum == 1) {
                    len = !Option.isIgnoreCase(this.regex.options) && br.back[0] <= 2 ? 1 : 2;
                    break;
                }
                len = 2 + 1 * br.backNum;
                break;
            }
            case 10: {
                len = 2;
                break;
            }
            case 5: {
                len = this.compileNonCECLengthQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                len = this.compileLengthEncloseNode((EncloseNode)node);
                break;
            }
            case 7: {
                len = this.compileLengthAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        return len;
    }

    private void ensure(int size) {
        if (size >= this.code.length) {
            int length;
            for (length = this.code.length << 1; length <= size; length <<= 1) {
            }
            int[] tmp = new int[length];
            System.arraycopy(this.code, 0, tmp, 0, this.code.length);
            this.code = tmp;
        }
    }

    private void addInt(int i) {
        if (this.codeLength >= this.code.length) {
            int[] tmp = new int[this.code.length << 1];
            System.arraycopy(this.code, 0, tmp, 0, this.code.length);
            this.code = tmp;
        }
        this.code[this.codeLength++] = i;
    }

    void setInt(int i, int offset) {
        this.ensure(offset);
        this.regex.code[offset] = i;
    }

    private void addObject(Object o) {
        if (this.regex.operands == null) {
            this.regex.operands = new Object[4];
        } else if (this.regex.operandLength >= this.regex.operands.length) {
            Object[] tmp = new Object[this.regex.operands.length << 1];
            System.arraycopy(this.regex.operands, 0, tmp, 0, this.regex.operands.length);
            this.regex.operands = tmp;
        }
        this.addInt(this.regex.operandLength);
        this.regex.operands[this.regex.operandLength++] = o;
    }

    private void addBytes(byte[] bytes, int p, int length) {
        this.ensure(this.codeLength + length);
        int end = p + length;
        while (p < end) {
            this.code[this.codeLength++] = bytes[p++];
        }
    }

    private void addInts(int[] ints, int length) {
        this.ensure(this.codeLength + length);
        System.arraycopy(ints, 0, this.code, this.codeLength, length);
        this.codeLength += length;
    }

    private void addOpcode(int opcode) {
        this.addInt(opcode);
        switch (opcode) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.regex.stackNeeded = true;
            }
        }
    }

    private void addStateCheckNum(int num) {
        this.addInt(num);
    }

    private void addRelAddr(int addr) {
        this.addInt(addr);
    }

    private void addAbsAddr(int addr) {
        this.addInt(addr);
    }

    private void addLength(int length) {
        this.addInt(length);
    }

    private void addMemNum(int num) {
        this.addInt(num);
    }

    private void addPointer(Object o) {
        this.addObject(o);
    }

    private void addOption(int option) {
        this.addInt(option);
    }

    private void addOpcodeRelAddr(int opcode, int addr) {
        this.addOpcode(opcode);
        this.addRelAddr(addr);
    }

    private void addOpcodeOption(int opcode, int option) {
        this.addOpcode(opcode);
        this.addOption(option);
    }

    private void addTemplate(byte[] bytes) {
        if (this.templateNum == 0) {
            this.templates = new byte[2][];
        } else if (this.templateNum == this.templates.length) {
            byte[][] tmp = new byte[this.templateNum * 2][];
            System.arraycopy(this.templates, 0, tmp, 0, this.templateNum);
            this.templates = tmp;
        }
        this.templates[this.templateNum++] = bytes;
    }
}

