/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.matching.pattern;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Match;
import io.prestosql.matching.Pattern;
import io.prestosql.matching.PatternVisitor;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class TypeOfPattern<T>
extends Pattern<T> {
    private final Class<T> expectedClass;

    public TypeOfPattern(Class<T> expectedClass) {
        this(expectedClass, Optional.empty());
    }

    public TypeOfPattern(Class<T> expectedClass, Optional<Pattern<?>> previous) {
        super(previous);
        this.expectedClass = Objects.requireNonNull(expectedClass, "expectedClass is null");
    }

    public Class<T> expectedClass() {
        return this.expectedClass;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        if (this.expectedClass.isInstance(object)) {
            return Stream.of(Match.of(captures));
        }
        return Stream.of(new Match[0]);
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitTypeOf(this);
    }
}

