/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.CompilerUtils;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class ConcatFunction
extends SqlScalarFunction {
    public static final ConcatFunction VARCHAR_CONCAT = new ConcatFunction(VarcharType.createUnboundedVarcharType().getTypeSignature(), "Concatenates given strings");
    public static final ConcatFunction VARBINARY_CONCAT = new ConcatFunction(VarbinaryType.VARBINARY.getTypeSignature(), "concatenates given varbinary values");

    private ConcatFunction(TypeSignature type, String description) {
        super(new FunctionMetadata(new Signature("concat", (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), type, (List<TypeSignature>)ImmutableList.of((Object)type), true), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, description, FunctionKind.SCALAR));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        if (arity < 2) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments");
        }
        Class<?> clazz = ConcatFunction.generateConcat(this.getFunctionMetadata().getSignature().getReturnType(), arity);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, "concat", Collections.nCopies(arity, Slice.class).toArray(new Class[arity]));
        return new ScalarFunctionImplementation(false, Collections.nCopies(arity, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    private static Class<?> generateConcat(TypeSignature type, int arity) {
        Failures.checkCondition(arity <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for string concatenation", new Object[0]);
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(type.getBase() + "_concat" + arity + "ScalarFunction"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        List parameters = (List)IntStream.range(0, arity).mapToObj(i -> Parameter.arg((String)("arg" + i), Slice.class)).collect(ImmutableList.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "concat", ParameterizedType.type(Slice.class), (Iterable)parameters);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable length = scope.declareVariable(Integer.TYPE, "length");
        body.append((BytecodeNode)length.set(BytecodeExpressions.constantInt((int)0)));
        for (int i2 = 0; i2 < arity; ++i2) {
            body.append((BytecodeNode)length.set(ConcatFunction.generateCheckedAdd((BytecodeExpression)length, ((Parameter)parameters.get(i2)).invoke("length", Integer.TYPE, new BytecodeExpression[0]))));
        }
        Variable result = scope.declareVariable(Slice.class, "result");
        body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic(Slices.class, (String)"allocate", Slice.class, (BytecodeExpression[])new BytecodeExpression[]{length})));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.append((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0)));
        for (int i3 = 0; i3 < arity; ++i3) {
            body.append((BytecodeNode)result.invoke("setBytes", Void.TYPE, new BytecodeExpression[]{position, (BytecodeExpression)parameters.get(i3)}));
            body.append((BytecodeNode)position.set(BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)((Parameter)parameters.get(i3)).invoke("length", Integer.TYPE, new BytecodeExpression[0]))));
        }
        body.getVariable(result).retObject();
        return CompilerUtils.defineClass(definition, Object.class, (Map<Long, MethodHandle>)ImmutableMap.of(), (ClassLoader)new DynamicClassLoader(ConcatFunction.class.getClassLoader()));
    }

    private static BytecodeExpression generateCheckedAdd(BytecodeExpression x, BytecodeExpression y) {
        return BytecodeExpressions.invokeStatic(ConcatFunction.class, (String)"checkedAdd", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{x, y});
    }

    @UsedByGeneratedCode
    public static int checkedAdd(int x, int y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
    }
}

