/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.state.CentralMomentsState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;

@AggregationFunction
@Description(value="Returns the central moments of the argument as an array")
public final class CentralMomentsAggregation {
    private CentralMomentsAggregation() {
    }

    @InputFunction
    public static void doubleInput(@AggregationState CentralMomentsState state, @SqlType(value="double") double value) {
        AggregationUtils.updateCentralMomentsState(state, value);
    }

    @InputFunction
    public static void bigintInput(@AggregationState CentralMomentsState state, @SqlType(value="bigint") long value) {
        AggregationUtils.updateCentralMomentsState(state, value);
    }

    @CombineFunction
    public static void combine(@AggregationState CentralMomentsState state, @AggregationState CentralMomentsState otherState) {
        AggregationUtils.mergeCentralMomentsState(state, otherState);
    }

    @AggregationFunction(value="skewness")
    @Description(value="Returns the skewness of the argument")
    @OutputFunction(value="double")
    public static void skewness(@AggregationState CentralMomentsState state, BlockBuilder out) {
        long n = state.getCount();
        if (n < 3L) {
            out.appendNull();
        } else {
            double result = Math.sqrt(n) * state.getM3() / Math.pow(state.getM2(), 1.5);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="kurtosis")
    @Description(value="Returns the (excess) kurtosis of the argument")
    @OutputFunction(value="double")
    public static void kurtosis(@AggregationState CentralMomentsState state, BlockBuilder out) {
        double n = state.getCount();
        if (n < 4.0) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double m4 = state.getM4();
            double result = (n - 1.0) * n * (n + 1.0) / ((n - 2.0) * (n - 3.0)) * m4 / (m2 * m2) - 3.0 * ((n - 1.0) * (n - 1.0)) / ((n - 2.0) * (n - 3.0));
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

