/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class FixedSplitSource
implements ConnectorSplitSource {
    private final List<ConnectorSplit> splits;
    private int offset;

    public FixedSplitSource(Iterable<? extends ConnectorSplit> splits) {
        Objects.requireNonNull(splits, "splits is null");
        ArrayList<ConnectorSplit> splitsList = new ArrayList<ConnectorSplit>();
        for (ConnectorSplit connectorSplit : splits) {
            splitsList.add(connectorSplit);
        }
        this.splits = Collections.unmodifiableList(splitsList);
    }

    @Override
    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        if (!partitionHandle.equals(NotPartitionedPartitionHandle.NOT_PARTITIONED)) {
            throw new IllegalArgumentException("partitionHandle must be NOT_PARTITIONED");
        }
        int remainingSplits = this.splits.size() - this.offset;
        int size = Math.min(remainingSplits, maxSize);
        List<ConnectorSplit> results = this.splits.subList(this.offset, this.offset + size);
        this.offset += size;
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(results, this.isFinished()));
    }

    @Override
    public boolean isFinished() {
        return this.offset >= this.splits.size();
    }

    @Override
    public void close() {
    }
}

