/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.units;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.airlift.units.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSize
implements Comparable<DataSize> {
    private static final Pattern DECIMAL_WITH_UNIT_PATTERN = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s*([a-zA-Z]+)\\s*$");
    private static final Unit[] DATASIZE_UNITS = Unit.values();
    private final long bytes;
    private final Unit unit;

    public static DataSize of(long size, Unit unit) throws IllegalArgumentException {
        Objects.requireNonNull(unit, "unit is null");
        Preconditions.checkArgument(size >= 0L, "size is negative: %s", size);
        if (unit == Unit.BYTE) {
            return new DataSize(size, unit);
        }
        try {
            return new DataSize(Math.multiplyExact(size, unit.inBytes()), unit);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(String.format("size is too large to be represented in bytes: %s%s", size, unit.getUnitString()));
        }
    }

    public static DataSize ofBytes(long bytes) {
        return new DataSize(bytes, Unit.BYTE);
    }

    public static DataSize succinctBytes(long bytes) {
        return DataSize.ofBytes(bytes).succinct();
    }

    @Deprecated
    public static DataSize succinctDataSize(double size, Unit unit) {
        return new DataSize(DataSize.roundDoubleSizeInUnitToLongBytes(size, unit), unit).succinct();
    }

    private DataSize(long bytes, Unit unit) {
        this.unit = Objects.requireNonNull(unit, "unit is null");
        Preconditions.checkArgument(bytes >= 0L, "bytes is negative");
        this.bytes = bytes;
    }

    @Deprecated
    public DataSize(double size, Unit unit) {
        this.unit = Objects.requireNonNull(unit, "unit is null");
        this.bytes = DataSize.roundDoubleSizeInUnitToLongBytes(size, unit);
    }

    public long toBytes() {
        return this.bytes;
    }

    @Deprecated
    public double getValue() {
        return this.getValue(this.unit);
    }

    public Unit getUnit() {
        return this.unit;
    }

    @Deprecated
    public double getValue(Unit unit) {
        Objects.requireNonNull(unit, "unit is null");
        if (unit == Unit.BYTE) {
            return this.bytes;
        }
        return (double)this.bytes * (1.0 / (double)unit.inBytes());
    }

    @Deprecated
    public long roundTo(Unit unit) {
        Objects.requireNonNull(unit, "unit is null");
        if (unit == Unit.BYTE) {
            return this.bytes;
        }
        double rounded = Math.floor(this.getValue(unit) + 0.5);
        Preconditions.checkArgument(rounded <= 9.223372036854776E18, "size is too large to be represented in requested unit as a long: %s%s", rounded, unit.getUnitString());
        return (long)rounded;
    }

    private Unit succinctUnit() {
        Unit unitToUse = Unit.BYTE;
        for (Unit unitToTest : DATASIZE_UNITS) {
            if (unitToTest.bytes > this.bytes) break;
            unitToUse = unitToTest;
        }
        return unitToUse;
    }

    @Deprecated
    public DataSize convertTo(Unit unit) {
        return this.to(unit);
    }

    public DataSize to(Unit unit) {
        return new DataSize(this.bytes, unit);
    }

    public DataSize succinct() {
        return this.to(this.succinctUnit());
    }

    @Deprecated
    public DataSize convertToMostSuccinctDataSize() {
        return this.succinct();
    }

    @JsonValue
    public String toBytesValueString() {
        return Long.toString(this.bytes) + Unit.BYTE.getUnitString();
    }

    public String toString() {
        if (this.unit == Unit.BYTE) {
            return this.toBytesValueString();
        }
        double unitValue = this.getValue();
        if (Math.floor(unitValue) == unitValue) {
            return Long.toString((long)unitValue) + this.unit.getUnitString();
        }
        return String.format(Locale.ENGLISH, "%.2f%s", unitValue, this.unit.getUnitString());
    }

    @JsonCreator
    public static DataSize valueOf(String size) throws IllegalArgumentException {
        Objects.requireNonNull(size, "size is null");
        Preconditions.checkArgument(!size.isEmpty(), "size is empty");
        Matcher longOrDouble = DECIMAL_WITH_UNIT_PATTERN.matcher(size);
        if (!longOrDouble.matches()) {
            throw new IllegalArgumentException("size is not a valid data size string: " + size);
        }
        Unit unit = Unit.fromUnitString(longOrDouble.group(2));
        String number = longOrDouble.group(1);
        if (number.indexOf(46) == -1) {
            return DataSize.of(Long.parseLong(number), unit);
        }
        return new DataSize(DataSize.roundDoubleSizeInUnitToLongBytes(Double.parseDouble(number), unit), unit);
    }

    private static long roundDoubleSizeInUnitToLongBytes(double size, Unit unit) {
        Preconditions.checkArgument(!Double.isInfinite(size), "size is infinite");
        Preconditions.checkArgument(!Double.isNaN(size), "size is not a number");
        Preconditions.checkArgument(size >= 0.0, "size is negative: %s", size);
        Objects.requireNonNull(unit, "unit is null");
        double rounded = Math.floor(size / (1.0 / (double)unit.inBytes()) + 0.5);
        Preconditions.checkArgument(rounded <= 9.223372036854776E18, "size is too large to be represented in requested unit as a long: %s%s", size, unit.getUnitString());
        return (long)rounded;
    }

    @Override
    public int compareTo(DataSize o) {
        return Long.compare(this.bytes, o.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.bytes == ((DataSize)o).bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }

    public static enum Unit {
        BYTE(1L, "B"),
        KILOBYTE(1024L, "kB"),
        MEGABYTE(0x100000L, "MB"),
        GIGABYTE(0x40000000L, "GB"),
        TERABYTE(0x10000000000L, "TB"),
        PETABYTE(0x4000000000000L, "PB");

        private final long bytes;
        private final String unitString;

        private Unit(long bytes, String unitString) {
            this.bytes = bytes;
            this.unitString = unitString;
        }

        public long inBytes() {
            return this.bytes;
        }

        public String getUnitString() {
            return this.unitString;
        }

        private static Unit fromUnitString(String unitString) {
            for (Unit unit : DATASIZE_UNITS) {
                if (!unit.unitString.equals(unitString)) continue;
                return unit;
            }
            throw new IllegalArgumentException("Unknown unit: " + unitString);
        }
    }
}

