/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.Type;

@ScalarFunction(value="map_values")
@Description(value="Returns the values of the given map(K,V) as an array")
public final class MapValues {
    private MapValues() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="array(V)")
    public static Block getValues(@TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block block) {
        BlockBuilder blockBuilder = valueType.createBlockBuilder(null, block.getPositionCount() / 2);
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            valueType.appendTo(block, i + 1, blockBuilder);
        }
        return blockBuilder.build();
    }
}

