/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.histogram;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.prestosql.array.IntBigArray;
import io.prestosql.array.LongBigArray;
import io.prestosql.operator.aggregation.histogram.GroupedTypedHistogram;
import io.prestosql.operator.aggregation.histogram.HashUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import org.openjdk.jol.info.ClassLayout;

public class ValueStore {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedTypedHistogram.class).instanceSize();
    private static final float MAX_FILL_RATIO = 0.5f;
    private static final int EMPTY_BUCKET = -1;
    private final BlockBuilder values;
    private int rehashCount;
    private int mask;
    private int bucketCount;
    private IntBigArray buckets;
    private final LongBigArray valueHashes;
    private int maxFill;

    @VisibleForTesting
    public ValueStore(int expectedSize, BlockBuilder values) {
        this.bucketCount = HashUtil.computeBucketCount(expectedSize, 0.5f);
        this.mask = this.bucketCount - 1;
        this.maxFill = HashUtil.calculateMaxFill(this.bucketCount, 0.5f);
        this.values = values;
        this.buckets = new IntBigArray(-1);
        this.buckets.ensureCapacity((long)this.bucketCount);
        this.valueHashes = new LongBigArray(-1L);
        this.valueHashes.ensureCapacity((long)this.bucketCount);
    }

    public int addAndGetPosition(Type type, Block block, int position, long valueHash) {
        if (this.values.getPositionCount() >= this.maxFill) {
            this.rehash();
        }
        int bucketId = this.getBucketId(valueHash, this.mask);
        int probeCount = 1;
        int originalBucketId = bucketId;
        while (true) {
            Preconditions.checkState((probeCount < this.bucketCount ? 1 : 0) != 0, (String)"could not find match for value nor empty slot in %s buckets", (int)this.bucketCount);
            int valuePointer = this.buckets.get((long)bucketId);
            if (valuePointer == -1) {
                valuePointer = this.values.getPositionCount();
                this.valueHashes.set((long)valuePointer, (long)((int)valueHash));
                type.appendTo(block, position, this.values);
                this.buckets.set((long)bucketId, valuePointer);
                return valuePointer;
            }
            if (type.equalTo(block, position, (Block)this.values, valuePointer)) {
                return valuePointer;
            }
            int probe = this.nextProbe(probeCount);
            bucketId = HashUtil.nextBucketId(originalBucketId, this.mask, probe);
            ++probeCount;
        }
    }

    private int getBucketId(long valueHash, int mask) {
        return (int)(valueHash & (long)mask);
    }

    @VisibleForTesting
    void rehash() {
        ++this.rehashCount;
        long newBucketCountLong = (long)this.bucketCount * 2L;
        if (newBucketCountLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 2147483647 entries (" + newBucketCountLong + ")");
        }
        int newBucketCount = (int)newBucketCountLong;
        int newMask = newBucketCount - 1;
        IntBigArray newBuckets = new IntBigArray(-1);
        newBuckets.ensureCapacity((long)newBucketCount);
        for (int i = 0; i < this.values.getPositionCount(); ++i) {
            long valueHash = this.valueHashes.get((long)i);
            int bucketId = this.getBucketId(valueHash, newMask);
            int probeCount = 1;
            while (newBuckets.get((long)bucketId) != -1) {
                int probe = this.nextProbe(probeCount);
                bucketId = HashUtil.nextBucketId(bucketId, newMask, probe);
                ++probeCount;
            }
            newBuckets.set((long)bucketId, i);
        }
        this.buckets = newBuckets;
        this.valueHashes.ensureCapacity((long)newBucketCount);
        this.bucketCount = newBucketCount;
        this.maxFill = HashUtil.calculateMaxFill(newBucketCount, 0.5f);
        this.mask = newMask;
    }

    public int getRehashCount() {
        return this.rehashCount;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.buckets.sizeOf();
    }

    private int nextProbe(int probe) {
        return HashUtil.nextProbeLinear(probe);
    }
}

