/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.protobufnative;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.TimestampProto;
import io.airlift.log.Logger;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarColumnMetadata;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;
import org.apache.pulsar.sql.presto.PulsarRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.protobufnative.PulsarProtobufNativeRowDecoder;

public class PulsarProtobufNativeRowDecoderFactory
implements PulsarRowDecoderFactory {
    private TypeManager typeManager;
    private static final Logger log = Logger.get(PulsarProtobufNativeRowDecoderFactory.class);

    public PulsarProtobufNativeRowDecoderFactory(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    @Override
    public PulsarRowDecoder createRowDecoder(TopicName topicName, SchemaInfo schemaInfo, Set<DecoderColumnHandle> columns) {
        return new PulsarProtobufNativeRowDecoder((GenericProtobufNativeSchema)GenericProtobufNativeSchema.of(schemaInfo), columns);
    }

    @Override
    public List<ColumnMetadata> extractColumnMetadata(TopicName topicName, SchemaInfo schemaInfo, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        Descriptors.Descriptor schema;
        String schemaJson = new String(schemaInfo.getSchema());
        if (StringUtils.isBlank((CharSequence)schemaJson)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        try {
            schema = ((GenericProtobufNativeSchema)GenericProtobufNativeSchema.of(schemaInfo)).getProtobufNativeSchema();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        List<ColumnMetadata> columnMetadata = schema.getFields().stream().map(field -> new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, field.getName()), this.parseProtobufPrestoType((Descriptors.FieldDescriptor)field), field.getType().toString(), null, false, false, handleKeyValueType, new PulsarColumnMetadata.DecoderExtraInfo(field.getName(), null, null))).collect(Collectors.toList());
        return columnMetadata;
    }

    private Type parseProtobufPrestoType(Descriptors.FieldDescriptor field) {
        BooleanType dataType;
        Descriptors.FieldDescriptor.JavaType type = field.getJavaType();
        switch (type) {
            case BOOLEAN: {
                dataType = BooleanType.BOOLEAN;
                break;
            }
            case BYTE_STRING: {
                dataType = VarbinaryType.VARBINARY;
                break;
            }
            case DOUBLE: {
                dataType = DoubleType.DOUBLE;
                break;
            }
            case ENUM: 
            case STRING: {
                dataType = VarcharType.createUnboundedVarcharType();
                break;
            }
            case FLOAT: {
                dataType = RealType.REAL;
                break;
            }
            case INT: {
                dataType = IntegerType.INTEGER;
                break;
            }
            case LONG: {
                dataType = BigintType.BIGINT;
                break;
            }
            case MESSAGE: {
                Descriptors.Descriptor msg = field.getMessageType();
                if (field.isMapField()) {
                    TypeSignature keyType = this.parseProtobufPrestoType(msg.findFieldByName("key")).getTypeSignature();
                    TypeSignature valueType = this.parseProtobufPrestoType(msg.findFieldByName("value")).getTypeSignature();
                    return this.typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType)));
                }
                if (TimestampProto.getDescriptor().toProto().getName().equals(msg.getFile().toProto().getName())) {
                    dataType = TimestampType.TIMESTAMP;
                    break;
                }
                dataType = RowType.from((List)((List)msg.getFields().stream().map(rowField -> new RowType.Field(Optional.of(rowField.getName()), this.parseProtobufPrestoType((Descriptors.FieldDescriptor)rowField))).collect(ImmutableList.toImmutableList())));
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + type.toString() + " for FieldDescriptor: " + field.getName());
            }
        }
        if (field.isRepeated() && !field.isMapField()) {
            dataType = new ArrayType((Type)dataType);
        }
        return dataType;
    }
}

