/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.state.CovarianceState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;

@AggregationFunction
public final class DoubleCovarianceAggregation {
    private DoubleCovarianceAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CovarianceState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateCovarianceState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(@AggregationState CovarianceState state, @AggregationState CovarianceState otherState) {
        AggregationUtils.mergeCovarianceState(state, otherState);
    }

    @AggregationFunction(value="covar_samp")
    @OutputFunction(value="double")
    public static void covarSamp(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() <= 1L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovarianceSample(state);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="covar_pop")
    @OutputFunction(value="double")
    public static void covarPop(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovariancePopulation(state);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

