/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.planner.SimplePlanVisitor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.type.TypeCoercion;
import io.prestosql.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeValidator
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        plan.accept(new Visitor(session, metadata, typeAnalyzer, types, warningCollector), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Session session;
        private final Metadata metadata;
        private final TypeCoercion typeCoercion;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeProvider types;
        private final WarningCollector warningCollector;

        public Visitor(Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.typeCoercion = new TypeCoercion(metadata::getType);
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            AggregationNode.Step step = node.getStep();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                switch (step) {
                    case SINGLE: {
                        this.checkSignature(symbol, aggregation.getResolvedFunction().getSignature());
                        this.checkCall(symbol, aggregation.getResolvedFunction().getSignature(), aggregation.getArguments());
                        break;
                    }
                    case FINAL: {
                        this.checkSignature(symbol, aggregation.getResolvedFunction().getSignature());
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            this.checkWindowFunctions(node.getWindowFunctions());
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Type expectedType = this.types.get(entry.getKey());
                if (entry.getValue() instanceof SymbolReference) {
                    SymbolReference symbolReference = (SymbolReference)entry.getValue();
                    this.verifyTypeSignature(entry.getKey(), expectedType.getTypeSignature(), this.types.get(Symbol.from((Expression)symbolReference)).getTypeSignature());
                    continue;
                }
                Type actualType = this.typeAnalyzer.getType(this.session, this.types, entry.getValue());
                this.verifyTypeSignature(entry.getKey(), expectedType.getTypeSignature(), actualType.getTypeSignature());
            }
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            ListMultimap<Symbol, Symbol> symbolMapping = node.getSymbolMapping();
            for (Symbol keySymbol : symbolMapping.keySet()) {
                List valueSymbols = symbolMapping.get((Object)keySymbol);
                Type expectedType = this.types.get(keySymbol);
                for (Symbol valueSymbol : valueSymbols) {
                    this.verifyTypeSignature(keySymbol, expectedType.getTypeSignature(), this.types.get(valueSymbol).getTypeSignature());
                }
            }
            return null;
        }

        private void checkWindowFunctions(Map<Symbol, WindowNode.Function> functions) {
            functions.forEach((symbol, function) -> {
                this.checkSignature((Symbol)symbol, function.getResolvedFunction().getSignature());
                this.checkCall((Symbol)symbol, function.getResolvedFunction().getSignature(), function.getArguments());
            });
        }

        private void checkSignature(Symbol symbol, Signature signature) {
            TypeSignature expectedTypeSignature = this.types.get(symbol).getTypeSignature();
            TypeSignature actualTypeSignature = signature.getReturnType();
            this.verifyTypeSignature(symbol, expectedTypeSignature, actualTypeSignature);
        }

        private void checkCall(Symbol symbol, Signature signature, List<Expression> arguments) {
            Type expectedType = this.types.get(symbol);
            Type actualType = this.metadata.getType(signature.getReturnType());
            this.verifyTypeSignature(symbol, expectedType.getTypeSignature(), actualType.getTypeSignature());
            Preconditions.checkArgument((signature.getArgumentTypes().size() == arguments.size() ? 1 : 0) != 0, (String)"expected %s arguments, but found %s arguments", (int)signature.getArgumentTypes().size(), (int)arguments.size());
            for (int i = 0; i < arguments.size(); ++i) {
                TypeSignature expectedTypeSignature = signature.getArgumentTypes().get(i);
                if (expectedTypeSignature.getBase().equals("function")) continue;
                TypeSignature actualTypeSignature = this.typeAnalyzer.getType(this.session, this.types, arguments.get(i)).getTypeSignature();
                this.verifyTypeSignature(symbol, expectedTypeSignature, actualTypeSignature);
            }
        }

        private void verifyTypeSignature(Symbol symbol, TypeSignature expected, TypeSignature actual) {
            if (!actual.equals((Object)UnknownType.UNKNOWN.getTypeSignature()) && !this.typeCoercion.isTypeOnlyCoercion(this.metadata.getType(actual), this.metadata.getType(expected))) {
                Preconditions.checkArgument((boolean)expected.equals((Object)actual), (String)"type of symbol '%s' is expected to be %s, but the actual type is %s", (Object)symbol, (Object)expected, (Object)actual);
            }
        }
    }
}

