/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientSelectedRole {
    private static final Pattern PATTERN = Pattern.compile("(ROLE|ALL|NONE)(\\{(.+?)\\})?");
    private final Type type;
    private final Optional<String> role;

    @JsonCreator
    public ClientSelectedRole(@JsonProperty(value="type") Type type, @JsonProperty(value="role") Optional<String> role) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.role = Objects.requireNonNull(role, "role is null");
        if (type == Type.ROLE && !role.isPresent()) {
            throw new IllegalArgumentException("Role must be present for the selected role type: " + (Object)((Object)type));
        }
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getRole() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientSelectedRole that = (ClientSelectedRole)o;
        return this.type == that.type && Objects.equals(this.role, that.role);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.role});
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.type);
        this.role.ifPresent(s -> result.append("{").append((String)s).append("}"));
        return result.toString();
    }

    public static ClientSelectedRole valueOf(String value) {
        Matcher m = PATTERN.matcher(value);
        if (m.matches()) {
            Type type = Type.valueOf(m.group(1));
            Optional<String> role = Optional.ofNullable(m.group(3));
            return new ClientSelectedRole(type, role);
        }
        throw new IllegalArgumentException("Could not parse selected role: " + value);
    }

    public static enum Type {
        ROLE,
        ALL,
        NONE;

    }
}

