/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.prestosql.Session;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.PlanNodeStatsEstimateMath;
import io.prestosql.cost.SimpleStatsRule;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsProvider;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;

public class ExchangeStatsRule
extends SimpleStatsRule<ExchangeNode> {
    private static final Pattern<ExchangeNode> PATTERN = Patterns.exchange();

    public ExchangeStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<ExchangeNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(ExchangeNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        Optional<PlanNodeStatsEstimate> estimate = Optional.empty();
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = node.getSources().get(i);
            PlanNodeStatsEstimate sourceStats = statsProvider.getStats(source);
            PlanNodeStatsEstimate sourceStatsWithMappedSymbols = this.mapToOutputSymbols(sourceStats, node.getInputs().get(i), node.getOutputSymbols());
            estimate = estimate.isPresent() ? Optional.of(PlanNodeStatsEstimateMath.addStatsAndMaxDistinctValues(estimate.get(), sourceStatsWithMappedSymbols)) : Optional.of(sourceStatsWithMappedSymbols);
        }
        Verify.verify((boolean)estimate.isPresent());
        return estimate;
    }

    private PlanNodeStatsEstimate mapToOutputSymbols(PlanNodeStatsEstimate estimate, List<Symbol> inputs, List<Symbol> outputs) {
        Preconditions.checkArgument((inputs.size() == outputs.size() ? 1 : 0) != 0, (Object)"Input symbols count does not match output symbols count");
        PlanNodeStatsEstimate.Builder mapped = PlanNodeStatsEstimate.builder().setOutputRowCount(estimate.getOutputRowCount());
        for (int i = 0; i < inputs.size(); ++i) {
            mapped.addSymbolStatistics(outputs.get(i), estimate.getSymbolStatistics(inputs.get(i)));
        }
        return mapped.build();
    }
}

