/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.HyperLogLogType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.P4HyperLogLogType;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.QuantileDigestParametricType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeNotFoundException;
import io.prestosql.spi.type.TypeParameter;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.type.ArrayParametricType;
import io.prestosql.type.CharParametricType;
import io.prestosql.type.CodePointsType;
import io.prestosql.type.ColorType;
import io.prestosql.type.DecimalParametricType;
import io.prestosql.type.FunctionParametricType;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.type.IntervalYearMonthType;
import io.prestosql.type.IpAddressType;
import io.prestosql.type.JoniRegexpType;
import io.prestosql.type.JsonPathType;
import io.prestosql.type.JsonType;
import io.prestosql.type.LikePatternType;
import io.prestosql.type.MapParametricType;
import io.prestosql.type.Re2JRegexpType;
import io.prestosql.type.RowParametricType;
import io.prestosql.type.UnknownType;
import io.prestosql.type.UuidType;
import io.prestosql.type.VarcharParametricType;
import io.prestosql.type.setdigest.SetDigestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TypeRegistry {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final ConcurrentMap<String, ParametricType> parametricTypes = new ConcurrentHashMap<String, ParametricType>();
    private final Cache<TypeSignature, Type> parametricTypeCache;

    public TypeRegistry(FeaturesConfig featuresConfig) {
        this.types.put(UnknownType.UNKNOWN.getTypeSignature(), (Type)UnknownType.UNKNOWN);
        this.addType((Type)BooleanType.BOOLEAN);
        this.addType((Type)BigintType.BIGINT);
        this.addType((Type)IntegerType.INTEGER);
        this.addType("int", (Type)IntegerType.INTEGER);
        this.addType((Type)SmallintType.SMALLINT);
        this.addType((Type)TinyintType.TINYINT);
        this.addType((Type)DoubleType.DOUBLE);
        this.addType((Type)RealType.REAL);
        this.addType((Type)VarbinaryType.VARBINARY);
        this.addType((Type)DateType.DATE);
        this.addType((Type)TimeType.TIME);
        this.addType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.addType((Type)TimestampType.TIMESTAMP);
        this.addType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        this.addType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        this.addType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        this.addType((Type)HyperLogLogType.HYPER_LOG_LOG);
        this.addType((Type)SetDigestType.SET_DIGEST);
        this.addType((Type)P4HyperLogLogType.P4_HYPER_LOG_LOG);
        this.addType((Type)JoniRegexpType.JONI_REGEXP);
        this.addType((Type)new Re2JRegexpType(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries()));
        this.addType((Type)LikePatternType.LIKE_PATTERN);
        this.addType((Type)JsonPathType.JSON_PATH);
        this.addType((Type)ColorType.COLOR);
        this.addType((Type)JsonType.JSON);
        this.addType((Type)CodePointsType.CODE_POINTS);
        this.addType((Type)IpAddressType.IPADDRESS);
        this.addType((Type)UuidType.UUID);
        this.addParametricType(VarcharParametricType.VARCHAR);
        this.addParametricType(CharParametricType.CHAR);
        this.addParametricType(DecimalParametricType.DECIMAL);
        this.addParametricType(RowParametricType.ROW);
        this.addParametricType(ArrayParametricType.ARRAY);
        this.addParametricType(MapParametricType.MAP);
        this.addParametricType(FunctionParametricType.FUNCTION);
        this.addParametricType((ParametricType)QuantileDigestParametricType.QDIGEST);
        this.parametricTypeCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    }

    public Type getType(TypeManager typeManager, TypeSignature signature) {
        Type type = (Type)this.types.get(signature);
        if (type == null) {
            try {
                return (Type)this.parametricTypeCache.get((Object)signature, () -> this.instantiateParametricType(typeManager, signature));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return type;
    }

    public Type getType(TypeManager typeManager, TypeId id) {
        return this.fromSqlType(typeManager, id.getId());
    }

    public Type fromSqlType(TypeManager typeManager, String sqlType) {
        return this.getType(typeManager, TypeSignatureTranslator.toTypeSignature(SQL_PARSER.createType(sqlType)));
    }

    private Type instantiateParametricType(TypeManager typeManager, TypeSignature signature) {
        Type instantiatedType;
        ArrayList<TypeParameter> parameters = new ArrayList<TypeParameter>();
        for (TypeSignatureParameter parameter : signature.getParameters()) {
            TypeParameter typeParameter = TypeParameter.of((TypeSignatureParameter)parameter, (TypeManager)typeManager);
            parameters.add(typeParameter);
        }
        ParametricType parametricType = (ParametricType)this.parametricTypes.get(signature.getBase().toLowerCase(Locale.ENGLISH));
        if (parametricType == null) {
            throw new TypeNotFoundException(signature);
        }
        try {
            instantiatedType = parametricType.createType(typeManager, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new TypeNotFoundException(signature, (Throwable)e);
        }
        return instantiatedType;
    }

    public Collection<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public Collection<ParametricType> getParametricTypes() {
        return ImmutableList.copyOf(this.parametricTypes.values());
    }

    public void addType(Type type) {
        Objects.requireNonNull(type, "type is null");
        Type existingType = this.types.putIfAbsent(type.getTypeSignature(), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object)type);
    }

    public void addType(String alias, Type type) {
        Objects.requireNonNull(alias, "alias is null");
        Objects.requireNonNull(type, "type is null");
        Type existingType = this.types.putIfAbsent(new TypeSignature(alias, new TypeSignatureParameter[0]), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Alias %s is already mapped to %s", (Object)alias, (Object)type);
    }

    public void addParametricType(ParametricType parametricType) {
        String name = parametricType.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.parametricTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type already registered: %s", (Object)name);
        this.parametricTypes.putIfAbsent(name, parametricType);
    }
}

