/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.cost.FilterStatsCalculator;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SemiJoinStatsCalculator;
import io.prestosql.cost.SimpleStatsRule;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsProvider;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimpleFilterProjectSemiJoinStatsRule
extends SimpleStatsRule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();
    private final Metadata metadata;
    private final FilterStatsCalculator filterStatsCalculator;

    public SimpleFilterProjectSemiJoinStatsRule(Metadata metadata, StatsNormalizer normalizer, FilterStatsCalculator filterStatsCalculator) {
        super(normalizer);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.filterStatsCalculator = Objects.requireNonNull(filterStatsCalculator, "filterStatsCalculator cannot be null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(FilterNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        SemiJoinNode semiJoinNode;
        PlanNode nodeSource = lookup.resolve(node.getSource());
        if (nodeSource instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)nodeSource;
            if (!projectNode.isIdentity()) {
                return Optional.empty();
            }
            PlanNode projectNodeSource = lookup.resolve(projectNode.getSource());
            if (!(projectNodeSource instanceof SemiJoinNode)) {
                return Optional.empty();
            }
            semiJoinNode = (SemiJoinNode)projectNodeSource;
        } else if (nodeSource instanceof SemiJoinNode) {
            semiJoinNode = (SemiJoinNode)nodeSource;
        } else {
            return Optional.empty();
        }
        return this.calculate(node, semiJoinNode, sourceStats, session, types);
    }

    private Optional<PlanNodeStatsEstimate> calculate(FilterNode filterNode, SemiJoinNode semiJoinNode, StatsProvider statsProvider, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(semiJoinNode.getSource());
        PlanNodeStatsEstimate filteringSourceStats = statsProvider.getStats(semiJoinNode.getFilteringSource());
        Symbol filteringSourceJoinSymbol = semiJoinNode.getFilteringSourceJoinSymbol();
        Symbol sourceJoinSymbol = semiJoinNode.getSourceJoinSymbol();
        Optional<SemiJoinOutputFilter> semiJoinOutputFilter = this.extractSemiJoinOutputFilter(filterNode.getPredicate(), semiJoinNode.getSemiJoinOutput());
        if (!semiJoinOutputFilter.isPresent()) {
            return Optional.empty();
        }
        PlanNodeStatsEstimate semiJoinStats = semiJoinOutputFilter.get().isNegated() ? SemiJoinStatsCalculator.computeAntiJoin(sourceStats, filteringSourceStats, sourceJoinSymbol, filteringSourceJoinSymbol) : SemiJoinStatsCalculator.computeSemiJoin(sourceStats, filteringSourceStats, sourceJoinSymbol, filteringSourceJoinSymbol);
        if (semiJoinStats.isOutputRowCountUnknown()) {
            return Optional.of(PlanNodeStatsEstimate.unknown());
        }
        PlanNodeStatsEstimate filteredStats = this.filterStatsCalculator.filterStats(semiJoinStats, semiJoinOutputFilter.get().getRemainingPredicate(), session, types);
        if (filteredStats.isOutputRowCountUnknown()) {
            return Optional.of(semiJoinStats.mapOutputRowCount(rowCount -> rowCount * 0.9));
        }
        return Optional.of(filteredStats);
    }

    private Optional<SemiJoinOutputFilter> extractSemiJoinOutputFilter(Expression predicate, Symbol semiJoinOutput) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(predicate);
        List semiJoinOutputReferences = (List)conjuncts.stream().filter(conjunct -> SimpleFilterProjectSemiJoinStatsRule.isSemiJoinOutputReference(conjunct, semiJoinOutput)).collect(ImmutableList.toImmutableList());
        if (semiJoinOutputReferences.size() != 1) {
            return Optional.empty();
        }
        Expression semiJoinOutputReference = (Expression)Iterables.getOnlyElement((Iterable)semiJoinOutputReferences);
        Expression remainingPredicate = ExpressionUtils.combineConjuncts(this.metadata, (Collection)conjuncts.stream().filter(conjunct -> conjunct != semiJoinOutputReference).collect(ImmutableList.toImmutableList()));
        boolean negated = semiJoinOutputReference instanceof NotExpression;
        return Optional.of(new SemiJoinOutputFilter(negated, remainingPredicate));
    }

    private static boolean isSemiJoinOutputReference(Expression conjunct, Symbol semiJoinOutput) {
        SymbolReference semiJoinOuputSymbolReference = semiJoinOutput.toSymbolReference();
        return conjunct.equals((Object)semiJoinOuputSymbolReference) || conjunct instanceof NotExpression && ((NotExpression)conjunct).getValue().equals((Object)semiJoinOuputSymbolReference);
    }

    private static class SemiJoinOutputFilter {
        private final boolean negated;
        private final Expression remainingPredicate;

        public SemiJoinOutputFilter(boolean negated, Expression remainingPredicate) {
            this.negated = negated;
            this.remainingPredicate = Objects.requireNonNull(remainingPredicate, "remainingPredicate cannot be null");
        }

        public boolean isNegated() {
            return this.negated;
        }

        public Expression getRemainingPredicate() {
            return this.remainingPredicate;
        }
    }
}

