/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerCacheImpl;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SnapshotMap;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StatsDoc(name="bookie", category="server", help="Bookie related stats")
public class InterleavedLedgerStorage
implements CompactableLedgerStorage,
EntryLogger.EntryLogListener {
    private static final Logger LOG = LoggerFactory.getLogger(InterleavedLedgerStorage.class);
    public static final long INVALID_ENTRYID = -1L;
    EntryLogger entryLogger;
    LedgerCache ledgerCache;
    protected CheckpointSource checkpointSource;
    protected Checkpointer checkpointer;
    private final CopyOnWriteArrayList<LedgerStorage.LedgerDeletionListener> ledgerDeletionListeners = Lists.newCopyOnWriteArrayList();
    protected final SnapshotMap<Long, Boolean> activeLedgers;
    GarbageCollectorThread gcThread;
    private final AtomicBoolean somethingWritten = new AtomicBoolean(false);
    private int pageSize;
    @StatsDoc(name="STORAGE_GET_OFFSET", help="Operation stats of getting offset from ledger cache", parent="BOOKIE_READ_ENTRY")
    private OpStatsLogger getOffsetStats;
    @StatsDoc(name="STORAGE_GET_ENTRY", help="Operation stats of getting entry from entry logger", parent="BOOKIE_READ_ENTRY", happensAfter="STORAGE_GET_OFFSET")
    private OpStatsLogger getEntryStats;
    private OpStatsLogger pageScanStats;
    private Counter retryCounter;

    @VisibleForTesting
    public InterleavedLedgerStorage() {
        this.activeLedgers = new SnapshotMap();
    }

    @Override
    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        this.initializeWithEntryLogListener(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, this, statsLogger, allocator);
    }

    void initializeWithEntryLogListener(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, EntryLogger.EntryLogListener entryLogListener, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        this.initializeWithEntryLogger(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, new EntryLogger(conf, ledgerDirsManager, entryLogListener, statsLogger.scope("entrylogger"), allocator), statsLogger);
    }

    @VisibleForTesting
    public void initializeWithEntryLogger(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, EntryLogger entryLogger, StatsLogger statsLogger) throws IOException {
        Preconditions.checkNotNull((Object)checkpointSource, (Object)"invalid null checkpoint source");
        Preconditions.checkNotNull((Object)checkpointer, (Object)"invalid null checkpointer");
        this.entryLogger = entryLogger;
        this.entryLogger.addListener(this);
        this.checkpointSource = checkpointSource;
        this.checkpointer = checkpointer;
        this.ledgerCache = new LedgerCacheImpl(conf, this.activeLedgers, null == indexDirsManager ? ledgerDirsManager : indexDirsManager, statsLogger);
        this.gcThread = new GarbageCollectorThread(conf, ledgerManager, this, statsLogger.scope("gc"));
        this.pageSize = conf.getPageSize();
        ledgerDirsManager.addLedgerDirsListener(this.getLedgerDirsListener());
        this.getOffsetStats = statsLogger.getOpStatsLogger("STORAGE_GET_OFFSET");
        this.getEntryStats = statsLogger.getOpStatsLogger("STORAGE_GET_ENTRY");
        this.pageScanStats = statsLogger.getOpStatsLogger("STORAGE_SCRUB_PAGES_SCANNED");
        this.retryCounter = statsLogger.getCounter("STORAGE_SCRUB_PAGE_RETRIES");
    }

    private LedgerDirsManager.LedgerDirsListener getLedgerDirsListener() {
        return new LedgerDirsManager.LedgerDirsListener(){

            @Override
            public void diskAlmostFull(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.suspendMajorGC();
                }
            }

            @Override
            public void diskFull(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.suspendMajorGC();
                    InterleavedLedgerStorage.this.gcThread.suspendMinorGC();
                }
            }

            @Override
            public void allDisksFull(boolean highPriorityWritesAllowed) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.suspendMajorGC();
                    InterleavedLedgerStorage.this.gcThread.suspendMinorGC();
                }
            }

            @Override
            public void diskWritable(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.disableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.resumeMajorGC();
                    InterleavedLedgerStorage.this.gcThread.resumeMinorGC();
                }
            }

            @Override
            public void diskJustWritable(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.resumeMinorGC();
                }
            }
        };
    }

    @Override
    public void forceGC() {
        this.gcThread.enableForceGC();
    }

    @Override
    public boolean isInForceGC() {
        return this.gcThread.isInForceGC();
    }

    @Override
    public void start() {
        this.gcThread.start();
    }

    @Override
    public void shutdown() throws InterruptedException {
        LOG.info("Shutting down InterleavedLedgerStorage");
        LOG.info("Shutting down GC thread");
        this.gcThread.shutdown();
        LOG.info("Shutting down entry logger");
        this.entryLogger.shutdown();
        try {
            this.ledgerCache.close();
        }
        catch (IOException e) {
            LOG.error("Error while closing the ledger cache", (Throwable)e);
        }
        LOG.info("Complete shutting down Ledger Storage");
    }

    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        return this.ledgerCache.setFenced(ledgerId);
    }

    @Override
    public boolean isFenced(long ledgerId) throws IOException {
        return this.ledgerCache.isFenced(ledgerId);
    }

    @Override
    public void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        this.ledgerCache.setExplicitLac(ledgerId, lac);
    }

    @Override
    public ByteBuf getExplicitLac(long ledgerId) {
        return this.ledgerCache.getExplicitLac(ledgerId);
    }

    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        this.ledgerCache.setMasterKey(ledgerId, masterKey);
    }

    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        return this.ledgerCache.readMasterKey(ledgerId);
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        return this.ledgerCache.ledgerExists(ledgerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastAddConfirmed(long ledgerId) throws IOException {
        Long lac = this.ledgerCache.getLastAddConfirmed(ledgerId);
        if (lac == null) {
            ByteBuf bb = this.getEntry(ledgerId, -1L);
            if (null == bb) {
                return -1L;
            }
            try {
                bb.skipBytes(16);
                lac = bb.readLong();
                lac = this.ledgerCache.updateLastAddConfirmed(ledgerId, lac);
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)bb);
            }
        }
        return lac;
    }

    @Override
    public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        return this.ledgerCache.waitForLastAddConfirmedUpdate(ledgerId, previousLAC, watcher);
    }

    @Override
    public void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        this.ledgerCache.cancelWaitForLastAddConfirmedUpdate(ledgerId, watcher);
    }

    @Override
    public long addEntry(ByteBuf entry) throws IOException {
        long ledgerId = entry.getLong(entry.readerIndex() + 0);
        long entryId = entry.getLong(entry.readerIndex() + 8);
        long lac = entry.getLong(entry.readerIndex() + 16);
        this.processEntry(ledgerId, entryId, entry);
        this.ledgerCache.updateLastAddConfirmed(ledgerId, lac);
        return entryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
        long offset;
        if (entryId == -1L) {
            entryId = this.ledgerCache.getLastEntry(ledgerId);
        }
        long startTimeNanos = MathUtils.nowInNano();
        boolean success = false;
        try {
            offset = this.ledgerCache.getEntryOffset(ledgerId, entryId);
            if (offset == 0L) {
                throw new Bookie.NoEntryException(ledgerId, entryId);
            }
            success = true;
        }
        finally {
            if (success) {
                this.getOffsetStats.registerSuccessfulEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            } else {
                this.getOffsetStats.registerFailedEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            }
        }
        startTimeNanos = MathUtils.nowInNano();
        success = false;
        try {
            ByteBuf retBytes = this.entryLogger.readEntry(ledgerId, entryId, offset);
            success = true;
            ByteBuf byteBuf = retBytes;
            return byteBuf;
        }
        finally {
            if (success) {
                this.getEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            } else {
                this.getEntryStats.registerFailedEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            }
        }
    }

    private void flushOrCheckpoint(boolean isCheckpointFlush) throws IOException {
        boolean flushFailed = false;
        try {
            this.ledgerCache.flushLedger(true);
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            throw e;
        }
        catch (IOException ioe) {
            LOG.error("Exception flushing Ledger cache", (Throwable)ioe);
            flushFailed = true;
        }
        try {
            if (isCheckpointFlush) {
                this.entryLogger.checkpoint();
            } else {
                this.entryLogger.flush();
            }
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            throw e;
        }
        catch (IOException ioe) {
            LOG.error("Exception flushing Ledger", (Throwable)ioe);
            flushFailed = true;
        }
        if (flushFailed) {
            throw new IOException("Flushing to storage failed, check logs");
        }
    }

    @Override
    public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        this.flushOrCheckpoint(true);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.somethingWritten.compareAndSet(true, false)) {
            return;
        }
        this.flushOrCheckpoint(false);
    }

    @Override
    public void deleteLedger(long ledgerId) throws IOException {
        this.activeLedgers.remove(ledgerId);
        this.ledgerCache.deleteLedger(ledgerId);
        for (LedgerStorage.LedgerDeletionListener listener : this.ledgerDeletionListeners) {
            listener.ledgerDeleted(ledgerId);
        }
    }

    @Override
    public Iterable<Long> getActiveLedgersInRange(long firstLedgerId, long lastLedgerId) {
        NavigableMap<Long, Boolean> bkActiveLedgersSnapshot = this.activeLedgers.snapshot();
        NavigableMap<Long, Boolean> subBkActiveLedgers = bkActiveLedgersSnapshot.subMap(firstLedgerId, true, lastLedgerId, false);
        return subBkActiveLedgers.keySet();
    }

    @Override
    public void updateEntriesLocations(Iterable<EntryLocation> locations) throws IOException {
        for (EntryLocation l : locations) {
            try {
                this.ledgerCache.putEntryOffset(l.ledger, l.entry, l.location);
            }
            catch (Bookie.NoLedgerException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Compaction failed for deleted ledger ledger: {} entry: {}", (Object)l.ledger, (Object)l.entry);
            }
        }
    }

    @Override
    public void flushEntriesLocationsIndex() throws IOException {
        this.ledgerCache.flushLedger(true);
    }

    @Override
    public EntryLogger getEntryLogger() {
        return this.entryLogger;
    }

    @Override
    public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        this.ledgerDeletionListeners.add(listener);
    }

    protected void processEntry(long ledgerId, long entryId, ByteBuf entry) throws IOException {
        this.processEntry(ledgerId, entryId, entry, true);
    }

    protected void processEntry(long ledgerId, long entryId, ByteBuf entry, boolean rollLog) throws IOException {
        this.somethingWritten.set(true);
        long pos = this.entryLogger.addEntry(ledgerId, entry, rollLog);
        this.ledgerCache.putEntryOffset(ledgerId, entryId, pos);
    }

    @Override
    public void onRotateEntryLog() {
        CheckpointSource.Checkpoint checkpoint = this.checkpointSource.newCheckpoint();
        this.checkpointer.startCheckpoint(checkpoint);
    }

    public LedgerCache.PageEntriesIterable getIndexEntries(long ledgerId) throws IOException {
        return this.ledgerCache.listEntries(ledgerId);
    }

    public LedgerCache.LedgerIndexMetadata readLedgerIndexMetadata(long ledgerId) throws IOException {
        return this.ledgerCache.readLedgerIndexMetadata(ledgerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public List<LedgerStorage.DetectedInconsistency> localConsistencyCheck(Optional<RateLimiter> rateLimiter) throws IOException {
        long checkStart = MathUtils.nowInNano();
        LOG.info("Starting localConsistencyCheck");
        long checkedLedgers = 0L;
        long checkedPages = 0L;
        MutableLong checkedEntries = new MutableLong(0L);
        MutableLong pageRetries = new MutableLong(0L);
        NavigableMap<Long, Boolean> bkActiveLedgersSnapshot = this.activeLedgers.snapshot();
        ArrayList<LedgerStorage.DetectedInconsistency> errors = new ArrayList<LedgerStorage.DetectedInconsistency>();
        for (Long ledger : bkActiveLedgersSnapshot.keySet()) {
            try (LedgerCache.PageEntriesIterable pages = this.ledgerCache.listEntries(ledger);){
                for (LedgerCache.PageEntries page : pages) {
                    LedgerEntryPage lep = page.getLEP();
                    try {
                        MutableBoolean retry = new MutableBoolean(false);
                        do {
                            retry.setValue(false);
                            int version = lep.getVersion();
                            MutableBoolean success = new MutableBoolean(true);
                            long start = MathUtils.nowInNano();
                            lep.getEntries((entry, offset) -> {
                                rateLimiter.ifPresent(RateLimiter::acquire);
                                try {
                                    this.entryLogger.checkEntry(ledger, entry, offset);
                                    checkedEntries.increment();
                                }
                                catch (EntryLogger.EntryLookupException e) {
                                    if (version != lep.getVersion()) {
                                        pageRetries.increment();
                                        if (lep.isDeleted()) {
                                            LOG.debug("localConsistencyCheck: ledger {} deleted", (Object)ledger);
                                        } else {
                                            LOG.debug("localConsistencyCheck: concurrent modification, retrying");
                                            retry.setValue(true);
                                            this.retryCounter.inc();
                                        }
                                        return false;
                                    }
                                    errors.add(new LedgerStorage.DetectedInconsistency(ledger, entry, e));
                                    LOG.error("Got error: ", (Throwable)e);
                                    success.setValue(false);
                                }
                                return true;
                            });
                            if (success.booleanValue()) {
                                this.pageScanStats.registerSuccessfulEvent(MathUtils.elapsedNanos((long)start), TimeUnit.NANOSECONDS);
                                continue;
                            }
                            this.pageScanStats.registerFailedEvent(MathUtils.elapsedNanos((long)start), TimeUnit.NANOSECONDS);
                        } while (retry.booleanValue());
                        ++checkedPages;
                    }
                    finally {
                        if (Collections.singletonList(lep).get(0) == null) continue;
                        lep.close();
                    }
                }
            }
            catch (Bookie.NoLedgerException | FileInfo.FileInfoDeletedException e) {
                if (this.activeLedgers.containsKey(ledger)) {
                    LOG.error("Cannot find ledger {}, should exist, exception is ", (Object)ledger, (Object)e);
                    errors.add(new LedgerStorage.DetectedInconsistency(ledger, -1L, e));
                } else {
                    LOG.debug("ledger {} deleted since snapshot taken", (Object)ledger);
                }
            }
            catch (Exception e) {
                throw new IOException("Got other exception in localConsistencyCheck", e);
            }
            ++checkedLedgers;
        }
        LOG.info("Finished localConsistencyCheck, took {}s to scan {} ledgers, {} pages, {} entries with {} retries, {} errors", new Object[]{TimeUnit.NANOSECONDS.toSeconds(MathUtils.elapsedNanos((long)checkStart)), checkedLedgers, checkedPages, checkedEntries.longValue(), pageRetries.longValue(), errors.size()});
        return errors;
    }

    @Override
    public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        return Collections.singletonList(this.gcThread.getGarbageCollectionStatus());
    }

    @Override
    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long ledgerId) throws IOException {
        return this.ledgerCache.getEntriesIterator(ledgerId);
    }

    public LedgerCache getLedgerCache() {
        return this.ledgerCache;
    }
}

