/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.CompletedWork;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.Work;
import io.prestosql.operator.project.InputChannels;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.operator.project.SelectedPositions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import java.util.List;

public class ConstantPageProjection
implements PageProjection {
    private static final InputChannels INPUT_PARAMETERS = new InputChannels((List<Integer>)ImmutableList.of());
    private final Type type;
    private final Block value;

    public ConstantPageProjection(Object value, Type type) {
        this.type = type;
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value);
        this.value = blockBuilder.build();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return INPUT_PARAMETERS;
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        return new CompletedWork<RunLengthEncodedBlock>(new RunLengthEncodedBlock(this.value, selectedPositions.size()));
    }
}

