/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.agent;

import java.lang.instrument.Instrumentation;
import java.util.logging.Logger;

public class TrimJavaVersionAgent {
    private static final Logger logger = Logger.getLogger(TrimJavaVersionAgent.class.getName());
    private static final String JAVA_VERSION = "java.version";

    public static String trimJavaVersion(String javaVersion) {
        String[] arr = javaVersion.split("\\.");
        if (arr.length <= 3) {
            return javaVersion;
        }
        return arr[0] + "." + arr[1] + "." + arr[2];
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        String javaVersion = System.getProperty(JAVA_VERSION);
        String trimVersion = TrimJavaVersionAgent.trimJavaVersion(javaVersion);
        logger.info("original java version " + javaVersion + " => trim java version " + trimVersion);
        System.setProperty(JAVA_VERSION, trimVersion);
    }
}

