/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataCacheConfig;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.api.extended.SessionEvent;

public class FaultInjectionMetadataStore
implements MetadataStoreExtended {
    private final MetadataStoreExtended store;
    private final AtomicReference<MetadataStoreException> alwaysFail;
    private final CopyOnWriteArrayList<Failure> failures;
    private final List<Consumer<SessionEvent>> sessionListeners = new CopyOnWriteArrayList<Consumer<SessionEvent>>();

    public FaultInjectionMetadataStore(MetadataStoreExtended store) {
        this.store = store;
        this.failures = new CopyOnWriteArrayList();
        this.alwaysFail = new AtomicReference();
    }

    @Override
    public CompletableFuture<Optional<GetResult>> get(String path) {
        Optional<MetadataStoreException> ex = this.programmedFailure(OperationType.GET, path);
        if (ex.isPresent()) {
            return FutureUtil.failedFuture((Throwable)ex.get());
        }
        return this.store.get(path);
    }

    @Override
    public CompletableFuture<List<String>> getChildren(String path) {
        Optional<MetadataStoreException> ex = this.programmedFailure(OperationType.GET_CHILDREN, path);
        if (ex.isPresent()) {
            return FutureUtil.failedFuture((Throwable)ex.get());
        }
        return this.store.getChildren(path);
    }

    @Override
    public CompletableFuture<Boolean> exists(String path) {
        Optional<MetadataStoreException> ex = this.programmedFailure(OperationType.EXISTS, path);
        if (ex.isPresent()) {
            return FutureUtil.failedFuture((Throwable)ex.get());
        }
        return this.store.exists(path);
    }

    @Override
    public CompletableFuture<Stat> put(String path, byte[] value, Optional<Long> expectedVersion) {
        Optional<MetadataStoreException> ex = this.programmedFailure(OperationType.PUT, path);
        if (ex.isPresent()) {
            return FutureUtil.failedFuture((Throwable)ex.get());
        }
        return this.store.put(path, value, expectedVersion);
    }

    @Override
    public CompletableFuture<Stat> put(String path, byte[] value, Optional<Long> expectedVersion, EnumSet<CreateOption> options) {
        Optional<MetadataStoreException> ex = this.programmedFailure(OperationType.PUT, path);
        if (ex.isPresent()) {
            return FutureUtil.failedFuture((Throwable)ex.get());
        }
        return this.store.put(path, value, expectedVersion, options);
    }

    @Override
    public CompletableFuture<Void> delete(String path, Optional<Long> expectedVersion) {
        Optional<MetadataStoreException> ex = this.programmedFailure(OperationType.DELETE, path);
        if (ex.isPresent()) {
            return FutureUtil.failedFuture((Throwable)ex.get());
        }
        return this.store.delete(path, expectedVersion);
    }

    @Override
    public CompletableFuture<Void> deleteRecursive(String path) {
        Optional<MetadataStoreException> ex = this.programmedFailure(OperationType.DELETE, path);
        if (ex.isPresent()) {
            return FutureUtil.failedFuture((Throwable)ex.get());
        }
        return this.store.deleteRecursive(path);
    }

    @Override
    public void registerListener(Consumer<Notification> listener) {
        this.store.registerListener(listener);
    }

    @Override
    public <T> MetadataCache<T> getMetadataCache(Class<T> clazz, MetadataCacheConfig cacheConfig) {
        return this.store.getMetadataCache(clazz, cacheConfig);
    }

    @Override
    public <T> MetadataCache<T> getMetadataCache(TypeReference<T> typeRef, MetadataCacheConfig cacheConfig) {
        return this.store.getMetadataCache(typeRef, cacheConfig);
    }

    @Override
    public <T> MetadataCache<T> getMetadataCache(MetadataSerde<T> serde, MetadataCacheConfig cacheConfig) {
        return this.store.getMetadataCache(serde, cacheConfig);
    }

    @Override
    public void registerSessionListener(Consumer<SessionEvent> listener) {
        this.store.registerSessionListener(listener);
        this.sessionListeners.add(listener);
    }

    @Override
    public void close() throws Exception {
        this.store.close();
    }

    public void failConditional(MetadataStoreException ex, BiPredicate<OperationType, String> predicate) {
        this.failures.add(new Failure(ex, predicate));
    }

    public void setAlwaysFail(MetadataStoreException ex) {
        this.alwaysFail.set(ex);
    }

    public void unsetAlwaysFail() {
        this.alwaysFail.set(null);
    }

    public void triggerSessionEvent(SessionEvent event) {
        this.sessionListeners.forEach(l -> l.accept(event));
    }

    private Optional<MetadataStoreException> programmedFailure(OperationType op, String path) {
        Optional<Failure> failure;
        MetadataStoreException ex = this.alwaysFail.get();
        if (ex != null) {
            return Optional.of(ex);
        }
        while ((failure = this.failures.stream().filter(f -> ((Failure)f).predicate.test(op, path)).findFirst()).isPresent()) {
            if (!this.failures.remove(failure.get())) continue;
            return failure.map(Failure::getException);
        }
        return Optional.empty();
    }

    private static class Failure {
        private final MetadataStoreException exception;
        private final BiPredicate<OperationType, String> predicate;

        public Failure(MetadataStoreException exception, BiPredicate<OperationType, String> predicate) {
            this.exception = exception;
            this.predicate = predicate;
        }

        public MetadataStoreException getException() {
            return this.exception;
        }

        public BiPredicate<OperationType, String> getPredicate() {
            return this.predicate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Failure)) {
                return false;
            }
            Failure other = (Failure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MetadataStoreException this$exception = this.getException();
            MetadataStoreException other$exception = other.getException();
            if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
                return false;
            }
            BiPredicate<OperationType, String> this$predicate = this.getPredicate();
            BiPredicate<OperationType, String> other$predicate = other.getPredicate();
            return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Failure;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MetadataStoreException $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            BiPredicate<OperationType, String> $predicate = this.getPredicate();
            result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
            return result;
        }

        public String toString() {
            return "FaultInjectionMetadataStore.Failure(exception=" + this.getException() + ", predicate=" + this.getPredicate() + ")";
        }
    }

    public static enum OperationType {
        GET,
        GET_CHILDREN,
        EXISTS,
        PUT,
        DELETE;

    }
}

