/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreImpl
implements MetaStore {
    private static final Logger log = LoggerFactory.getLogger(MetaStoreImpl.class);
    private static final String BASE_NODE = "/managed-ledgers";
    private static final String PREFIX = "/managed-ledgers/";
    private final MetadataStore store;
    private final OrderedExecutor executor;
    private static final int MAGIC_MANAGED_INFO_METADATA = 18296;
    private final MLDataFormats.CompressionType ledgerInfoCompressionType;
    private final MLDataFormats.CompressionType cursorInfoCompressionType;

    public MetaStoreImpl(MetadataStore store, OrderedExecutor executor) {
        this.store = store;
        this.executor = executor;
        this.ledgerInfoCompressionType = MLDataFormats.CompressionType.NONE;
        this.cursorInfoCompressionType = MLDataFormats.CompressionType.NONE;
    }

    public MetaStoreImpl(MetadataStore store, OrderedExecutor executor, String ledgerInfoCompressionType, String cursorInfoCompressionType) {
        this.store = store;
        this.executor = executor;
        this.ledgerInfoCompressionType = this.parseCompressionType(ledgerInfoCompressionType);
        this.cursorInfoCompressionType = this.parseCompressionType(cursorInfoCompressionType);
    }

    private MLDataFormats.CompressionType parseCompressionType(String value) {
        MLDataFormats.CompressionType compressionType;
        if (StringUtils.isEmpty((String)value)) {
            return MLDataFormats.CompressionType.NONE;
        }
        try {
            compressionType = MLDataFormats.CompressionType.valueOf(value);
        }
        catch (Exception e) {
            log.error("Failed to get compression type {} error msg: {}.", (Object)value, (Object)e.getMessage());
            throw e;
        }
        return compressionType;
    }

    @Override
    public void getManagedLedgerInfo(String ledgerName, boolean createIfMissing, Map<String, String> properties, MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo> callback) {
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.get(path).thenAcceptAsync(optResult -> {
            if (optResult.isPresent()) {
                try {
                    MLDataFormats.ManagedLedgerInfo info = this.parseManagedLedgerInfo(((GetResult)optResult.get()).getValue());
                    info = MetaStoreImpl.updateMLInfoTimestamp(info);
                    callback.operationComplete(info, ((GetResult)optResult.get()).getStat());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(MetaStoreImpl.getException(e));
                }
            } else if (createIfMissing) {
                log.info("Creating '{}'", (Object)path);
                ((CompletableFuture)this.store.put(path, new byte[0], Optional.of(-1L)).thenAccept(stat -> {
                    MLDataFormats.ManagedLedgerInfo.Builder ledgerBuilder = MLDataFormats.ManagedLedgerInfo.newBuilder();
                    if (properties != null) {
                        properties.forEach((k, v) -> ledgerBuilder.addProperties(MLDataFormats.KeyValue.newBuilder().setKey((String)k).setValue((String)v).build()));
                    }
                    callback.operationComplete(ledgerBuilder.build(), (Stat)stat);
                })).exceptionally(ex -> {
                    callback.operationFailed(MetaStoreImpl.getException(ex));
                    return null;
                });
            } else {
                callback.operationFailed(new ManagedLedgerException.MetadataNotFoundException("Managed ledger not found"));
            }
        }, (Executor)this.executor.chooseThread((Object)ledgerName))).exceptionally(ex -> {
            try {
                this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            }
            catch (RejectedExecutionException e) {
                CompletableFuture.runAsync(() -> callback.operationFailed(MetaStoreImpl.getException(ex)));
            }
            return null;
        });
    }

    @Override
    public void asyncUpdateLedgerIds(String ledgerName, MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Updating metadata version={} with content={}", new Object[]{ledgerName, stat, mlInfo});
        }
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.put(path, this.compressLedgerInfo(mlInfo), Optional.of(stat.getVersion())).thenAcceptAsync(newVersion -> callback.operationComplete((Void)null, (Stat)newVersion), (Executor)this.executor.chooseThread((Object)ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void getCursors(String ledgerName, MetaStore.MetaStoreCallback<List<String>> callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Get cursors list", (Object)ledgerName);
        }
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.getChildren(path).thenAcceptAsync(cursors -> callback.operationComplete((List<String>)cursors, null), (Executor)this.executor.chooseThread((Object)ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncGetCursorInfo(String ledgerName, String cursorName, MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo> callback) {
        String path = PREFIX + ledgerName + "/" + cursorName;
        if (log.isDebugEnabled()) {
            log.debug("Reading from {}", (Object)path);
        }
        ((CompletableFuture)this.store.get(path).thenAcceptAsync(optRes -> {
            if (optRes.isPresent()) {
                try {
                    MLDataFormats.ManagedCursorInfo info = this.parseManagedCursorInfo(((GetResult)optRes.get()).getValue());
                    callback.operationComplete(info, ((GetResult)optRes.get()).getStat());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(MetaStoreImpl.getException(e));
                }
            } else {
                callback.operationFailed(new ManagedLedgerException.MetadataNotFoundException("Cursor metadata not found"));
            }
        }, (Executor)this.executor.chooseThread((Object)ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncUpdateCursorInfo(String ledgerName, String cursorName, MLDataFormats.ManagedCursorInfo info, Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        long expectedVersion;
        log.info("[{}] [{}] Updating cursor info ledgerId={} mark-delete={}:{}", new Object[]{ledgerName, cursorName, info.getCursorsLedgerId(), info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId()});
        String path = PREFIX + ledgerName + "/" + cursorName;
        byte[] content = this.compressCursorInfo(info);
        if (stat != null) {
            expectedVersion = stat.getVersion();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Creating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
        } else {
            expectedVersion = -1L;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Updating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
        }
        ((CompletableFuture)this.store.put(path, content, Optional.of(expectedVersion)).thenAcceptAsync(optStat -> callback.operationComplete((Void)null, (Stat)optStat), (Executor)this.executor.chooseThread((Object)ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncRemoveCursor(String ledgerName, String cursorName, MetaStore.MetaStoreCallback<Void> callback) {
        String path = PREFIX + ledgerName + "/" + cursorName;
        log.info("[{}] Remove cursor={}", (Object)ledgerName, (Object)cursorName);
        ((CompletableFuture)this.store.delete(path, Optional.empty()).thenAcceptAsync(v -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] cursor delete done", (Object)ledgerName, (Object)cursorName);
            }
            callback.operationComplete(null, null);
        }, (Executor)this.executor.chooseThread((Object)ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> {
                Throwable actEx = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (actEx instanceof MetadataStoreException.NotFoundException) {
                    log.info("[{}] [{}] cursor delete done because it did not exist.", (Object)ledgerName, (Object)cursorName);
                    callback.operationComplete(null, null);
                    return;
                }
                callback.operationFailed(MetaStoreImpl.getException(ex));
            }));
            return null;
        });
    }

    @Override
    public void removeManagedLedger(String ledgerName, MetaStore.MetaStoreCallback<Void> callback) {
        log.info("[{}] Remove ManagedLedger", (Object)ledgerName);
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.delete(path, Optional.empty()).thenAcceptAsync(v -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] managed ledger delete done", (Object)ledgerName);
            }
            callback.operationComplete(null, null);
        }, (Executor)this.executor.chooseThread((Object)ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public Iterable<String> getManagedLedgers() throws ManagedLedgerException.MetaStoreException {
        try {
            return (Iterable)this.store.getChildren(BASE_NODE).join();
        }
        catch (CompletionException e) {
            throw MetaStoreImpl.getException(e);
        }
    }

    @Override
    public CompletableFuture<Boolean> asyncExists(String path) {
        return this.store.exists(PREFIX + path);
    }

    private static MLDataFormats.ManagedLedgerInfo updateMLInfoTimestamp(MLDataFormats.ManagedLedgerInfo info) {
        ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> infoList = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>(info.getLedgerInfoCount());
        long currentTime = System.currentTimeMillis();
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo : info.getLedgerInfoList()) {
            if (!ledgerInfo.hasTimestamp() || ledgerInfo.getTimestamp() == 0L) {
                MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder singleInfoBuilder = ledgerInfo.toBuilder();
                singleInfoBuilder.setTimestamp(currentTime);
                infoList.add(singleInfoBuilder.build());
                continue;
            }
            infoList.add(ledgerInfo);
        }
        MLDataFormats.ManagedLedgerInfo.Builder mlInfo = MLDataFormats.ManagedLedgerInfo.newBuilder();
        mlInfo.addAllLedgerInfo(infoList);
        if (info.hasTerminatedPosition()) {
            mlInfo.setTerminatedPosition(info.getTerminatedPosition());
        }
        mlInfo.addAllProperties(info.getPropertiesList());
        return mlInfo.build();
    }

    private static ManagedLedgerException.MetaStoreException getException(Throwable t) {
        if (t.getCause() instanceof MetadataStoreException.BadVersionException) {
            return new ManagedLedgerException.BadVersionException(t.getMessage());
        }
        return new ManagedLedgerException.MetaStoreException(t);
    }

    public byte[] compressLedgerInfo(MLDataFormats.ManagedLedgerInfo managedLedgerInfo) {
        if (this.ledgerInfoCompressionType.equals((Object)MLDataFormats.CompressionType.NONE)) {
            return managedLedgerInfo.toByteArray();
        }
        MLDataFormats.ManagedLedgerInfoMetadata mlInfoMetadata = MLDataFormats.ManagedLedgerInfoMetadata.newBuilder().setCompressionType(this.ledgerInfoCompressionType).setUncompressedSize(managedLedgerInfo.getSerializedSize()).build();
        return this.compressManagedInfo(managedLedgerInfo.toByteArray(), mlInfoMetadata.toByteArray(), mlInfoMetadata.getSerializedSize(), this.ledgerInfoCompressionType);
    }

    public byte[] compressCursorInfo(MLDataFormats.ManagedCursorInfo managedCursorInfo) {
        if (this.cursorInfoCompressionType.equals((Object)MLDataFormats.CompressionType.NONE)) {
            return managedCursorInfo.toByteArray();
        }
        MLDataFormats.ManagedCursorInfoMetadata metadata = MLDataFormats.ManagedCursorInfoMetadata.newBuilder().setCompressionType(this.cursorInfoCompressionType).setUncompressedSize(managedCursorInfo.getSerializedSize()).build();
        return this.compressManagedInfo(managedCursorInfo.toByteArray(), metadata.toByteArray(), metadata.getSerializedSize(), this.cursorInfoCompressionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MLDataFormats.ManagedLedgerInfo parseManagedLedgerInfo(byte[] data) throws InvalidProtocolBufferException {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])data);
        byte[] metadataBytes = this.extractCompressMetadataBytes(byteBuf);
        if (metadataBytes != null) {
            try {
                MLDataFormats.ManagedLedgerInfoMetadata metadata = MLDataFormats.ManagedLedgerInfoMetadata.parseFrom(metadataBytes);
                MLDataFormats.ManagedLedgerInfo managedLedgerInfo = MLDataFormats.ManagedLedgerInfo.parseFrom(this.getCompressionCodec(metadata.getCompressionType()).decode(byteBuf, metadata.getUncompressedSize()).nioBuffer());
                return managedLedgerInfo;
            }
            catch (Exception e) {
                log.error("Failed to parse managedLedgerInfo metadata, fall back to parse managedLedgerInfo directly.", (Throwable)e);
                MLDataFormats.ManagedLedgerInfo managedLedgerInfo = MLDataFormats.ManagedLedgerInfo.parseFrom(data);
                return managedLedgerInfo;
            }
            finally {
                byteBuf.release();
            }
        }
        return MLDataFormats.ManagedLedgerInfo.parseFrom(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MLDataFormats.ManagedCursorInfo parseManagedCursorInfo(byte[] data) throws InvalidProtocolBufferException {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])data);
        byte[] metadataBytes = this.extractCompressMetadataBytes(byteBuf);
        if (metadataBytes != null) {
            try {
                MLDataFormats.ManagedCursorInfoMetadata metadata = MLDataFormats.ManagedCursorInfoMetadata.parseFrom(metadataBytes);
                MLDataFormats.ManagedCursorInfo managedCursorInfo = MLDataFormats.ManagedCursorInfo.parseFrom(this.getCompressionCodec(metadata.getCompressionType()).decode(byteBuf, metadata.getUncompressedSize()).nioBuffer());
                return managedCursorInfo;
            }
            catch (Exception e) {
                log.error("Failed to parse ManagedCursorInfo metadata, fall back to parse ManagedCursorInfo directly", (Throwable)e);
                MLDataFormats.ManagedCursorInfo managedCursorInfo = MLDataFormats.ManagedCursorInfo.parseFrom(data);
                return managedCursorInfo;
            }
            finally {
                byteBuf.release();
            }
        }
        return MLDataFormats.ManagedCursorInfo.parseFrom(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compressManagedInfo(byte[] info, byte[] metadata, int metadataSerializedSize, MLDataFormats.CompressionType compressionType) {
        if (compressionType == null || compressionType.equals((Object)MLDataFormats.CompressionType.NONE)) {
            return info;
        }
        ByteBuf metadataByteBuf = null;
        ByteBuf encodeByteBuf = null;
        try {
            metadataByteBuf = PulsarByteBufAllocator.DEFAULT.buffer(metadataSerializedSize + 6, metadataSerializedSize + 6);
            metadataByteBuf.writeShort(18296);
            metadataByteBuf.writeInt(metadataSerializedSize);
            metadataByteBuf.writeBytes(metadata);
            encodeByteBuf = this.getCompressionCodec(compressionType).encode(Unpooled.wrappedBuffer((byte[])info));
            CompositeByteBuf compositeByteBuf = PulsarByteBufAllocator.DEFAULT.compositeBuffer();
            compositeByteBuf.addComponent(true, metadataByteBuf);
            compositeByteBuf.addComponent(true, encodeByteBuf);
            byte[] dataBytes = new byte[compositeByteBuf.readableBytes()];
            compositeByteBuf.readBytes(dataBytes);
            byte[] byArray = dataBytes;
            return byArray;
        }
        finally {
            if (metadataByteBuf != null) {
                metadataByteBuf.release();
            }
            if (encodeByteBuf != null) {
                encodeByteBuf.release();
            }
        }
    }

    private byte[] extractCompressMetadataBytes(ByteBuf data) {
        if (data.readableBytes() > 0 && data.readShort() == 18296) {
            int metadataSize = data.readInt();
            byte[] metadataBytes = new byte[metadataSize];
            data.readBytes(metadataBytes);
            return metadataBytes;
        }
        return null;
    }

    private CompressionCodec getCompressionCodec(MLDataFormats.CompressionType compressionType) {
        return CompressionCodecProvider.getCompressionCodec((CompressionType)CompressionType.valueOf((String)compressionType.name()));
    }
}

