/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.sanity.AllFunctionsResolved;
import io.prestosql.sql.planner.sanity.DynamicFiltersChecker;
import io.prestosql.sql.planner.sanity.NoDuplicatePlanNodeIdsChecker;
import io.prestosql.sql.planner.sanity.NoIdentifierLeftChecker;
import io.prestosql.sql.planner.sanity.NoSubqueryExpressionLeftChecker;
import io.prestosql.sql.planner.sanity.SugarFreeChecker;
import io.prestosql.sql.planner.sanity.TableScanValidator;
import io.prestosql.sql.planner.sanity.TypeValidator;
import io.prestosql.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import io.prestosql.sql.planner.sanity.ValidateDependenciesChecker;
import io.prestosql.sql.planner.sanity.ValidateStreamingAggregations;
import io.prestosql.sql.planner.sanity.VerifyNoFilteredAggregations;
import io.prestosql.sql.planner.sanity.VerifyOnlyOneOutputNode;

public final class PlanSanityChecker {
    public static final PlanSanityChecker DISTRIBUTED_PLAN_SANITY_CHECKER = new PlanSanityChecker(false);
    private final Multimap<Stage, Checker> checkers;

    public PlanSanityChecker(boolean forceSingleNode) {
        this.checkers = ImmutableListMultimap.builder().putAll((Object)Stage.INTERMEDIATE, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new AllFunctionsResolved(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode()}).putAll((Object)Stage.FINAL, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new SugarFreeChecker(), new AllFunctionsResolved(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations(), new ValidateAggregationsWithDefaultValues(forceSingleNode), new ValidateStreamingAggregations(), new DynamicFiltersChecker(), new TableScanValidator()}).build();
    }

    public void validateFinalPlan(PlanNode planNode, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.FINAL).forEach(checker -> checker.validate(planNode, session, metadata, typeAnalyzer, types, warningCollector));
    }

    public void validateIntermediatePlan(PlanNode planNode, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.INTERMEDIATE).forEach(checker -> checker.validate(planNode, session, metadata, typeAnalyzer, types, warningCollector));
    }

    private static enum Stage {
        INTERMEDIATE,
        FINAL;

    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, Metadata var3, TypeAnalyzer var4, TypeProvider var5, WarningCollector var6);
    }
}

