/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PruneCountAggregationOverScalar
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final Metadata metadata;

    public PruneCountAggregationOverScalar(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        if (!parent.hasDefaultOutput() || parent.getOutputSymbols().size() != 1) {
            return Rule.Result.empty();
        }
        FunctionId countFunctionId = this.metadata.resolveFunction(QualifiedName.of((String)"count"), (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId();
        Map<Symbol, AggregationNode.Aggregation> assignments = parent.getAggregations();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : assignments.entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            Objects.requireNonNull(aggregation, "aggregation is null");
            ResolvedFunction resolvedFunction = aggregation.getResolvedFunction();
            if (countFunctionId.equals(resolvedFunction.getFunctionId())) continue;
            return Rule.Result.empty();
        }
        if (!assignments.isEmpty() && QueryCardinalityUtil.isScalar(parent.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(parent.getId(), parent.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")))));
        }
        return Rule.Result.empty();
    }
}

