/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.DropSchema;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class DropSchemaTask
implements DataDefinitionTask<DropSchema> {
    @Override
    public String getName() {
        return "DROP SCHEMA";
    }

    @Override
    public String explain(DropSchema statement, List<Expression> parameters) {
        return "DROP SCHEMA " + statement.getSchemaName();
    }

    @Override
    public ListenableFuture<?> execute(DropSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        CatalogSchemaName schema;
        if (statement.isCascade()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CASCADE is not yet supported for DROP SCHEMA");
        }
        Session session = stateMachine.getSession();
        if (!metadata.schemaExists(session, schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName())))) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", schema);
            }
            return Futures.immediateFuture(null);
        }
        accessControl.checkCanDropSchema(session.toSecurityContext(), schema);
        metadata.dropSchema(session, schema);
        return Futures.immediateFuture(null);
    }
}

