/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.DropRole;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DropRoleTask
implements DataDefinitionTask<DropRole> {
    @Override
    public String getName() {
        return "DROP ROLE";
    }

    @Override
    public ListenableFuture<?> execute(DropRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        String role = statement.getName().getValue().toLowerCase(Locale.ENGLISH);
        accessControl.checkCanDropRole(session.toSecurityContext(), role, catalog);
        Set<String> existingRoles = metadata.listRoles(session, catalog);
        if (!existingRoles.contains(role)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", role);
        }
        metadata.dropRole(session, role, catalog);
        return Futures.immediateFuture(null);
    }
}

