/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import io.prestosql.connector.system.StaticSystemTablesProvider;
import io.prestosql.connector.system.SystemPageSourceProvider;
import io.prestosql.connector.system.SystemSplitManager;
import io.prestosql.connector.system.SystemTablesMetadata;
import io.prestosql.connector.system.SystemTablesProvider;
import io.prestosql.connector.system.SystemTransactionHandle;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.transaction.InternalConnector;
import io.prestosql.transaction.TransactionId;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class SystemConnector
implements InternalConnector {
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction;

    public SystemConnector(InternalNodeManager nodeManager, Set<SystemTable> tables, Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction) {
        this(nodeManager, new StaticSystemTablesProvider(tables), transactionHandleFunction);
    }

    public SystemConnector(InternalNodeManager nodeManager, SystemTablesProvider tables, Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(tables, "tables is null");
        Objects.requireNonNull(transactionHandleFunction, "transactionHandleFunction is null");
        this.metadata = new SystemTablesMetadata(tables);
        this.splitManager = new SystemSplitManager(nodeManager, tables);
        this.pageSourceProvider = new SystemPageSourceProvider(tables);
        this.transactionHandleFunction = transactionHandleFunction;
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new SystemTransactionHandle(transactionId, this.transactionHandleFunction);
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }
}

