/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MarkDistinctNode
extends PlanNode {
    private final PlanNode source;
    private final Symbol markerSymbol;
    private final Optional<Symbol> hashSymbol;
    private final List<Symbol> distinctSymbols;

    @JsonCreator
    public MarkDistinctNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="markerSymbol") Symbol markerSymbol, @JsonProperty(value="distinctSymbols") List<Symbol> distinctSymbols, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        this.source = source;
        this.markerSymbol = markerSymbol;
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        Objects.requireNonNull(distinctSymbols, "distinctSymbols is null");
        Preconditions.checkArgument((!distinctSymbols.isEmpty() ? 1 : 0) != 0, (Object)"distinctSymbols cannot be empty");
        this.distinctSymbols = ImmutableList.copyOf(distinctSymbols);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.markerSymbol).build();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Symbol getMarkerSymbol() {
        return this.markerSymbol;
    }

    @JsonProperty
    public List<Symbol> getDistinctSymbols() {
        return this.distinctSymbols;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMarkDistinct(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new MarkDistinctNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.markerSymbol, this.distinctSymbols, this.hashSymbol);
    }
}

