/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class ByteBufSchema
extends AbstractSchema<ByteBuf> {
    private static final ByteBufSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static ByteBufSchema of() {
        return INSTANCE;
    }

    public byte[] encode(ByteBuf message) {
        if (message == null) {
            return null;
        }
        return ByteBufUtil.getBytes((ByteBuf)message);
    }

    public ByteBuf decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    @Override
    public ByteBuf decode(ByteBuf byteBuf) {
        return byteBuf;
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfoImpl().setName("ByteBuf").setType(SchemaType.BYTES).setSchema(new byte[0]);
        INSTANCE = new ByteBufSchema();
    }
}

