/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.pulsar.client.admin.Clusters;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;

public class ClustersImpl
extends BaseResource
implements Clusters {
    private final WebTarget adminClusters;

    public ClustersImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminClusters = web.path("/admin/v2/clusters");
    }

    public List<String> getClusters() throws PulsarAdminException {
        return (List)this.sync(this::getClustersAsync);
    }

    public CompletableFuture<List<String>> getClustersAsync() {
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(this.adminClusters, new InvocationCallback<List<String>>(){

            public void completed(List<String> clusters) {
                future.complete(clusters);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public ClusterData getCluster(String cluster) throws PulsarAdminException {
        return (ClusterData)this.sync(() -> this.getClusterAsync(cluster));
    }

    public CompletableFuture<ClusterData> getClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        final CompletableFuture<ClusterData> future = new CompletableFuture<ClusterData>();
        this.asyncGetRequest(path, new InvocationCallback<ClusterDataImpl>(){

            public void completed(ClusterDataImpl clusterData) {
                future.complete(clusterData);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void createCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        this.sync(() -> this.createClusterAsync(cluster, clusterData));
    }

    public CompletableFuture<Void> createClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPutRequest(path, Entity.entity((Object)((ClusterDataImpl)clusterData), (String)"application/json"));
    }

    public void updateCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        this.sync(() -> this.updateClusterAsync(cluster, clusterData));
    }

    public CompletableFuture<Void> updateClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPostRequest(path, Entity.entity((Object)((ClusterDataImpl)clusterData), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updatePeerClusterNames(String cluster, LinkedHashSet<String> peerClusterNames) throws PulsarAdminException {
        this.sync(() -> this.updatePeerClusterNamesAsync(cluster, peerClusterNames));
    }

    public CompletableFuture<Void> updatePeerClusterNamesAsync(String cluster, LinkedHashSet<String> peerClusterNames) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        return this.asyncPostRequest(path, Entity.entity(peerClusterNames, (String)"application/json"));
    }

    public Set<String> getPeerClusterNames(String cluster) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getPeerClusterNamesAsync(cluster));
    }

    public CompletableFuture<Set<String>> getPeerClusterNamesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        final CompletableFuture<Set<String>> future = new CompletableFuture<Set<String>>();
        this.asyncGetRequest(path, new InvocationCallback<Set<String>>(){

            public void completed(Set<String> clusterNames) {
                future.complete(clusterNames);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void deleteCluster(String cluster) throws PulsarAdminException {
        this.sync(() -> this.deleteClusterAsync(cluster));
    }

    public CompletableFuture<Void> deleteClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, NamespaceIsolationData> getNamespaceIsolationPolicies(String cluster) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getNamespaceIsolationPoliciesAsync(cluster));
    }

    public CompletableFuture<Map<String, NamespaceIsolationData>> getNamespaceIsolationPoliciesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies");
        final CompletableFuture<Map<String, NamespaceIsolationData>> future = new CompletableFuture<Map<String, NamespaceIsolationData>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, NamespaceIsolationDataImpl>>(){

            public void completed(Map<String, NamespaceIsolationDataImpl> stringNamespaceIsolationDataMap) {
                HashMap result = new HashMap();
                stringNamespaceIsolationDataMap.forEach(result::put);
                future.complete(result);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<BrokerNamespaceIsolationData> getBrokersWithNamespaceIsolationPolicy(String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getBrokersWithNamespaceIsolationPolicyAsync(cluster));
    }

    public CompletableFuture<List<BrokerNamespaceIsolationData>> getBrokersWithNamespaceIsolationPolicyAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers");
        final CompletableFuture<List<BrokerNamespaceIsolationData>> future = new CompletableFuture<List<BrokerNamespaceIsolationData>>();
        this.asyncGetRequest(path, new InvocationCallback<List<BrokerNamespaceIsolationDataImpl>>(){

            public void completed(List<BrokerNamespaceIsolationDataImpl> brokerNamespaceIsolationData) {
                ArrayList<BrokerNamespaceIsolationDataImpl> data = new ArrayList<BrokerNamespaceIsolationDataImpl>(brokerNamespaceIsolationData);
                future.complete(data);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public BrokerNamespaceIsolationData getBrokerWithNamespaceIsolationPolicy(String cluster, String broker) throws PulsarAdminException {
        return (BrokerNamespaceIsolationData)this.sync(() -> this.getBrokerWithNamespaceIsolationPolicyAsync(cluster, broker));
    }

    public CompletableFuture<BrokerNamespaceIsolationData> getBrokerWithNamespaceIsolationPolicyAsync(String cluster, String broker) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers").path(broker);
        final CompletableFuture<BrokerNamespaceIsolationData> future = new CompletableFuture<BrokerNamespaceIsolationData>();
        this.asyncGetRequest(path, new InvocationCallback<BrokerNamespaceIsolationDataImpl>(){

            public void completed(BrokerNamespaceIsolationDataImpl brokerNamespaceIsolationData) {
                future.complete(brokerNamespaceIsolationData);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void createNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    public CompletableFuture<Void> createNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    public void updateNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    public CompletableFuture<Void> updateNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    public void deleteNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceIsolationPolicyAsync(cluster, policyName));
    }

    public CompletableFuture<Void> deleteNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncDeleteRequest(path);
    }

    private void setNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData));
    }

    private CompletableFuture<Void> setNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncPostRequest(path, Entity.entity((Object)namespaceIsolationData, (String)"application/json"));
    }

    public NamespaceIsolationData getNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        return (NamespaceIsolationData)this.sync(() -> this.getNamespaceIsolationPolicyAsync(cluster, policyName));
    }

    public CompletableFuture<NamespaceIsolationData> getNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        final CompletableFuture<NamespaceIsolationData> future = new CompletableFuture<NamespaceIsolationData>();
        this.asyncGetRequest(path, new InvocationCallback<NamespaceIsolationDataImpl>(){

            public void completed(NamespaceIsolationDataImpl namespaceIsolationData) {
                future.complete(namespaceIsolationData);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void createFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    public CompletableFuture<Void> createFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    public void updateFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    public CompletableFuture<Void> updateFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    public void deleteFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        this.sync(() -> this.deleteFailureDomainAsync(cluster, domainName));
    }

    public CompletableFuture<Void> deleteFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, FailureDomain> getFailureDomains(String cluster) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getFailureDomainsAsync(cluster));
    }

    public CompletableFuture<Map<String, FailureDomain>> getFailureDomainsAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains");
        final CompletableFuture<Map<String, FailureDomain>> future = new CompletableFuture<Map<String, FailureDomain>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, FailureDomainImpl>>(){

            public void completed(Map<String, FailureDomainImpl> failureDomains) {
                HashMap<String, FailureDomainImpl> result = new HashMap<String, FailureDomainImpl>(failureDomains);
                future.complete(result);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public FailureDomain getFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        return (FailureDomain)this.sync(() -> this.getFailureDomainAsync(cluster, domainName));
    }

    public CompletableFuture<FailureDomain> getFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        final CompletableFuture<FailureDomain> future = new CompletableFuture<FailureDomain>();
        this.asyncGetRequest(path, new InvocationCallback<FailureDomainImpl>(){

            public void completed(FailureDomainImpl failureDomain) {
                future.complete(failureDomain);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(ClustersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    private void setDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.sync(() -> this.setDomainAsync(cluster, domainName, domain));
    }

    private CompletableFuture<Void> setDomainAsync(String cluster, String domainName, FailureDomain domain) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncPostRequest(path, Entity.entity((Object)((FailureDomainImpl)domain), (String)"application/json"));
    }
}

