/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.reflect.Reflection;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import io.prestosql.plugin.base.util.LoggingInvocationHandler;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlConfig;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.ForwardingAccessControl;
import io.prestosql.security.GroupProviderManager;
import io.prestosql.spi.security.GroupProvider;
import java.lang.reflect.InvocationHandler;
import org.weakref.jmx.guice.ExportBinder;

public class AccessControlModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(AccessControlConfig.class);
        binder.bind(AccessControlManager.class).in(Scopes.SINGLETON);
        binder.bind(GroupProviderManager.class).in(Scopes.SINGLETON);
        binder.bind(GroupProvider.class).to(GroupProviderManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(AccessControlManager.class).withGeneratedName();
    }

    @Provides
    @Singleton
    public AccessControl createAccessControl(AccessControlManager accessControlManager) {
        Logger logger = Logger.get(AccessControl.class);
        AccessControl loggingInvocationsAccessControl = (AccessControl)Reflection.newProxy(AccessControl.class, (InvocationHandler)new LoggingInvocationHandler((Object)accessControlManager, (LoggingInvocationHandler.ParameterNamesProvider)new LoggingInvocationHandler.ReflectiveParameterNamesProvider(), arg_0 -> ((Logger)logger).debug(arg_0)));
        return ForwardingAccessControl.of(() -> {
            if (logger.isDebugEnabled()) {
                return loggingInvocationsAccessControl;
            }
            return accessControlManager;
        });
    }
}

