/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.LongState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.RemoveInputFunction;
import io.prestosql.spi.type.BigintType;

@AggregationFunction(value="count")
public final class CountAggregation {
    private CountAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongState state) {
        state.setLong(state.getLong() + 1L);
    }

    @RemoveInputFunction
    public static void removeInput(@AggregationState LongState state) {
        state.setLong(state.getLong() - 1L);
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, @AggregationState LongState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getLong());
    }
}

