/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BigintOperators;
import io.prestosql.type.IntervalYearMonthType;

@AggregationFunction(value="sum")
public final class IntervalYearToMonthSumAggregation {
    private IntervalYearToMonthSumAggregation() {
    }

    @InputFunction
    public static void sum(NullableLongState state, @SqlType(value="interval year to month") long value) {
        state.setNull(false);
        state.setLong(BigintOperators.add(state.getLong(), value));
    }

    @CombineFunction
    public static void combine(NullableLongState state, NullableLongState otherState) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong(BigintOperators.add(state.getLong(), otherState.getLong()));
    }

    @OutputFunction(value="interval year to month")
    public static void output(NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, state, out);
    }
}

