/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import io.prestosql.GroupByHashPageIndexerFactory;
import io.prestosql.PagesIndexPageSorter;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.ConnectorAwareNodeManager;
import io.prestosql.metadata.InMemoryNodeManager;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.PagesIndex;
import io.prestosql.server.ServerConfig;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.type.InternalTypeManager;
import io.prestosql.version.EmbedVersion;

public final class TestingConnectorContext
implements ConnectorContext {
    private final NodeManager nodeManager = new ConnectorAwareNodeManager(new InMemoryNodeManager(), "testenv", new CatalogName("test"));
    private final VersionEmbedder versionEmbedder = new EmbedVersion(new ServerConfig());
    private final TypeManager typeManager;
    private final PageSorter pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
    private final PageIndexerFactory pageIndexerFactory;

    public TestingConnectorContext() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.pageIndexerFactory = new GroupByHashPageIndexerFactory(new JoinCompiler(metadata));
        this.typeManager = new InternalTypeManager(metadata);
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public VersionEmbedder getVersionEmbedder() {
        return this.versionEmbedder;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public PageSorter getPageSorter() {
        return this.pageSorter;
    }

    public PageIndexerFactory getPageIndexerFactory() {
        return this.pageIndexerFactory;
    }

    public ClassLoader duplicatePluginClassLoader() {
        return this.getClass().getClassLoader();
    }
}

