/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.informationschema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public class InformationSchemaSplit
implements ConnectorSplit {
    private final List<HostAddress> addresses;

    @JsonCreator
    public InformationSchemaSplit(@JsonProperty(value="addresses") List<HostAddress> addresses) {
        Objects.requireNonNull(addresses, "hosts is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"hosts is empty");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }
}

