/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.authentication;

import io.prestosql.plugin.base.authentication.KerberosAuthentication;
import io.prestosql.plugin.base.authentication.KerberosTicketUtils;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;

public class CachingKerberosAuthentication {
    private final KerberosAuthentication kerberosAuthentication;
    @GuardedBy(value="this")
    private Subject subject;
    @GuardedBy(value="this")
    private long nextRefreshTime;

    public CachingKerberosAuthentication(KerberosAuthentication kerberosAuthentication) {
        this.kerberosAuthentication = Objects.requireNonNull(kerberosAuthentication, "kerberosAuthentication is null");
    }

    public synchronized Subject getSubject() {
        if (this.subject == null || this.nextRefreshTime < System.currentTimeMillis()) {
            this.subject = Objects.requireNonNull(this.kerberosAuthentication.getSubject(), "kerberosAuthentication.getSubject() is null");
            KerberosTicket tgtTicket = KerberosTicketUtils.getTicketGrantingTicket(this.subject);
            this.nextRefreshTime = KerberosTicketUtils.getRefreshTime(tgtTicket);
        }
        return this.subject;
    }
}

