/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.AnnotationBehaviorMergeStrategy;
import org.apache.bval.jsr.metadata.CompositeBuilder;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.EmptyBuilder;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Validate;

public class DualBuilder {
    public static <T> MetadataBuilder.ForBean<T> forBean(Class<T> beanClass, MetadataBuilder.ForBean<T> primaryDelegate, MetadataBuilder.ForBean<T> customDelegate, ApacheValidatorFactory validatorFactory) {
        return new ForBean<T>(primaryDelegate, DualBuilder.wrapCustom(customDelegate, beanClass, validatorFactory));
    }

    private static <T> MetadataBuilder.ForBean<T> wrapCustom(MetadataBuilder.ForBean<T> customDelegate, Class<T> beanClass, ApacheValidatorFactory validatorFactory) {
        Meta.ForClass<T> meta = new Meta.ForClass<T>(beanClass);
        Map<String, MetadataBuilder.ForContainer<Method>> getters = customDelegate.getGetters(meta);
        Map<Signature, MetadataBuilder.ForExecutable<Method>> methods = customDelegate.getMethods(meta);
        if (getters.isEmpty() && methods.keySet().stream().noneMatch(Signature::isGetter)) {
            return customDelegate;
        }
        CompositeBuilder composite = CompositeBuilder.with(validatorFactory, AnnotationBehaviorMergeStrategy.consensus());
        TreeMap<String, MetadataBuilder.ForContainer<Method>> mergedGetters = new TreeMap<String, MetadataBuilder.ForContainer<Method>>(getters);
        methods.forEach((k, v) -> {
            if (k.isGetter()) {
                mergedGetters.compute(Methods.propertyName(k.getName()), (p, d) -> {
                    Method getter = Methods.getter(beanClass, p);
                    return Stream.of(d, v.getReturnValue(new Meta.ForMethod(getter))).filter(Objects::nonNull).collect(composite.composeContainer());
                });
            }
        });
        TreeMap<Signature, MetadataBuilder.ForExecutable<Method>> mergedMethods = new TreeMap<Signature, MetadataBuilder.ForExecutable<Method>>(methods);
        getters.forEach((k, v) -> {
            Method getter = Methods.getter(beanClass, k);
            Signature signature = Signature.of(getter);
            MetadataBuilder.ForContainer rv = methods.containsKey(signature) ? Stream.of(((MetadataBuilder.ForExecutable)methods.get(signature)).getReturnValue(new Meta.ForMethod(getter)), v).collect(composite.composeContainer()) : v;
            mergedMethods.put(signature, new CustomWrapper.ForGetterMethod(rv));
        });
        return new CustomWrapper.ForBean<T>(customDelegate, mergedGetters, mergedMethods);
    }

    private static class CustomWrapper {
        private CustomWrapper() {
        }

        private static class ForGetterMethod
        implements MetadataBuilder.ForExecutable<Method> {
            private final MetadataBuilder.ForContainer<Method> returnValue;

            private ForGetterMethod(MetadataBuilder.ForContainer<Method> returnValue) {
                this.returnValue = Validate.notNull(returnValue, "returnValue", new Object[0]);
            }

            @Override
            public AnnotationBehavior getAnnotationBehavior() {
                return this.returnValue.getAnnotationBehavior();
            }

            @Override
            public MetadataBuilder.ForContainer<Method> getReturnValue(Meta<Method> meta) {
                return this.returnValue;
            }

            @Override
            public MetadataBuilder.ForElement<Method> getCrossParameter(Meta<Method> meta) {
                return EmptyBuilder.instance().forElement();
            }

            @Override
            public List<MetadataBuilder.ForContainer<Parameter>> getParameters(Meta<Method> meta) {
                return Collections.emptyList();
            }
        }

        private static class ForBean<T>
        implements MetadataBuilder.ForBean<T> {
            private final MetadataBuilder.ForBean<T> wrapped;
            private final Map<String, MetadataBuilder.ForContainer<Method>> getters;
            private final Map<Signature, MetadataBuilder.ForExecutable<Method>> methods;

            ForBean(MetadataBuilder.ForBean<T> wrapped, Map<String, MetadataBuilder.ForContainer<Method>> getters, Map<Signature, MetadataBuilder.ForExecutable<Method>> methods) {
                this.wrapped = Validate.notNull(wrapped, "wrapped", new Object[0]);
                this.getters = Validate.notNull(getters, "getters", new Object[0]);
                this.methods = Validate.notNull(methods, "methods", new Object[0]);
            }

            @Override
            public AnnotationBehavior getAnnotationBehavior() {
                return this.wrapped.getAnnotationBehavior();
            }

            @Override
            public MetadataBuilder.ForClass<T> getClass(Meta<Class<T>> meta) {
                return this.wrapped.getClass(meta);
            }

            @Override
            public Map<String, MetadataBuilder.ForContainer<Field>> getFields(Meta<Class<T>> meta) {
                return this.wrapped.getFields(meta);
            }

            @Override
            public Map<String, MetadataBuilder.ForContainer<Method>> getGetters(Meta<Class<T>> meta) {
                return this.getters;
            }

            @Override
            public Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> meta) {
                return this.wrapped.getConstructors(meta);
            }

            @Override
            public Map<Signature, MetadataBuilder.ForExecutable<Method>> getMethods(Meta<Class<T>> meta) {
                return this.methods;
            }
        }
    }

    private static class ForExecutable<DELEGATE extends MetadataBuilder.ForExecutable<E>, E extends Executable>
    extends Delegator<DELEGATE>
    implements MetadataBuilder.ForExecutable<E> {
        ForExecutable(Delegator<?> parent, DELEGATE primaryDelegate, DELEGATE customDelegate) {
            super(parent, primaryDelegate, customDelegate);
        }

        @Override
        public MetadataBuilder.ForContainer<E> getReturnValue(Meta<E> meta) {
            return new ForContainer(this, ((MetadataBuilder.ForExecutable)this.primaryDelegate).getReturnValue(meta), ((MetadataBuilder.ForExecutable)this.customDelegate).getReturnValue(meta));
        }

        @Override
        public List<MetadataBuilder.ForContainer<Parameter>> getParameters(Meta<E> meta) {
            List<MetadataBuilder.ForContainer<Parameter>> primaries = ((MetadataBuilder.ForExecutable)this.primaryDelegate).getParameters(meta);
            List<MetadataBuilder.ForContainer<Parameter>> customs = ((MetadataBuilder.ForExecutable)this.customDelegate).getParameters(meta);
            Validate.validState(primaries.size() == customs.size(), "Mismatched parameter counts: %d vs. %d", primaries.size(), customs.size());
            return IntStream.range(0, primaries.size()).mapToObj(n -> new ForContainer(this, (MetadataBuilder.ForContainer)primaries.get(n), (MetadataBuilder.ForContainer)customs.get(n))).collect(ToUnmodifiable.list());
        }

        @Override
        public MetadataBuilder.ForElement<E> getCrossParameter(Meta<E> meta) {
            return new ForElement(this, ((MetadataBuilder.ForExecutable)this.primaryDelegate).getCrossParameter(meta), ((MetadataBuilder.ForExecutable)this.customDelegate).getCrossParameter(meta));
        }
    }

    private static class ForContainer<DELEGATE extends MetadataBuilder.ForContainer<E>, E extends AnnotatedElement>
    extends ForElement<DELEGATE, E>
    implements MetadataBuilder.ForContainer<E> {
        ForContainer(Delegator<?> parent, DELEGATE primaryDelegate, DELEGATE customDelegate) {
            super(parent, primaryDelegate, customDelegate);
        }

        @Override
        public final boolean isCascade(Meta<E> meta) {
            return this.activeDelegates().anyMatch(d -> d.isCascade(meta));
        }

        @Override
        public final Set<GroupConversion> getGroupConversions(Meta<E> meta) {
            return this.activeDelegates().map(d -> d.getGroupConversions(meta)).flatMap(Collection::stream).collect(ToUnmodifiable.set());
        }

        @Override
        public final Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> getContainerElementTypes(Meta<E> meta) {
            return this.merge(b -> b.getContainerElementTypes(meta), (t, u) -> new ForContainer<MetadataBuilder.ForContainer, E>(this, (MetadataBuilder.ForContainer)t, (MetadataBuilder.ForContainer)u), EmptyBuilder.instance()::forContainer);
        }
    }

    private static class ForClass<T>
    extends ForElement<MetadataBuilder.ForClass<T>, Class<T>>
    implements MetadataBuilder.ForClass<T> {
        ForClass(Delegator<?> parent, MetadataBuilder.ForClass<T> primaryDelegate, MetadataBuilder.ForClass<T> customDelegate) {
            super(parent, primaryDelegate, customDelegate);
        }

        @Override
        public List<Class<?>> getGroupSequence(Meta<Class<T>> meta) {
            List<Class<?>> customGroupSequence = ((MetadataBuilder.ForClass)this.customDelegate).getGroupSequence(meta);
            if (customGroupSequence != null) {
                return customGroupSequence;
            }
            return ((MetadataBuilder.ForClass)this.customDelegate).getAnnotationBehavior() == AnnotationBehavior.EXCLUDE ? null : ((MetadataBuilder.ForClass)this.primaryDelegate).getGroupSequence(meta);
        }
    }

    private static class ForElement<DELEGATE extends MetadataBuilder.ForElement<E>, E extends AnnotatedElement>
    extends Delegator<DELEGATE>
    implements MetadataBuilder.ForElement<E> {
        ForElement(Delegator<?> parent, DELEGATE primaryDelegate, DELEGATE customDelegate) {
            super(parent, primaryDelegate, customDelegate);
        }

        @Override
        public final Annotation[] getDeclaredConstraints(Meta<E> meta) {
            return (Annotation[])this.activeDelegates().map(d -> d.getDeclaredConstraints(meta)).flatMap(Stream::of).toArray(Annotation[]::new);
        }
    }

    private static class ForBean<T>
    extends Delegator<MetadataBuilder.ForBean<T>>
    implements MetadataBuilder.ForBean<T> {
        ForBean(MetadataBuilder.ForBean<T> primaryDelegate, MetadataBuilder.ForBean<T> customDelegate) {
            super(null, primaryDelegate, customDelegate);
        }

        @Override
        public MetadataBuilder.ForClass<T> getClass(Meta<Class<T>> meta) {
            return new ForClass<T>((Delegator<?>)this, ((MetadataBuilder.ForBean)this.primaryDelegate).getClass(meta), ((MetadataBuilder.ForBean)this.customDelegate).getClass(meta));
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Field>> getFields(Meta<Class<T>> meta) {
            return this.merge(b -> b.getFields(meta), (t, u) -> new ForContainer(this, (MetadataBuilder.ForContainer)t, (MetadataBuilder.ForContainer)u), EmptyBuilder.instance()::forContainer);
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Method>> getGetters(Meta<Class<T>> meta) {
            return this.merge(b -> b.getGetters(meta), (t, u) -> new ForContainer(this, (MetadataBuilder.ForContainer)t, (MetadataBuilder.ForContainer)u), EmptyBuilder.instance()::forContainer);
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> meta) {
            return this.merge(b -> b.getConstructors(meta), (t, u) -> new ForExecutable(this, (MetadataBuilder.ForExecutable)t, (MetadataBuilder.ForExecutable)u), EmptyBuilder.instance()::forExecutable);
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Method>> getMethods(Meta<Class<T>> meta) {
            return this.merge(b -> b.getMethods(meta), (t, u) -> new ForExecutable(this, (MetadataBuilder.ForExecutable)t, (MetadataBuilder.ForExecutable)u), EmptyBuilder.instance()::forExecutable);
        }
    }

    private static class Delegator<DELEGATE extends HasAnnotationBehavior>
    implements HasAnnotationBehavior {
        private final Delegator<?> parent;
        protected final DELEGATE primaryDelegate;
        protected final DELEGATE customDelegate;

        Delegator(Delegator<?> parent, DELEGATE primaryDelegate, DELEGATE customDelegate) {
            this.parent = parent;
            this.primaryDelegate = (HasAnnotationBehavior)Validate.notNull(primaryDelegate, "primaryDelegate", new Object[0]);
            this.customDelegate = (HasAnnotationBehavior)Validate.notNull(customDelegate, "customDelegate", new Object[0]);
        }

        AnnotationBehavior getCustomAnnotationBehavior() {
            AnnotationBehavior annotationBehavior = this.customDelegate.getAnnotationBehavior();
            Validate.validState(annotationBehavior != null, "null %s returned from %s", AnnotationBehavior.class.getSimpleName(), this.customDelegate);
            if (annotationBehavior == AnnotationBehavior.ABSTAIN && this.parent != null) {
                return this.parent.getCustomAnnotationBehavior();
            }
            return annotationBehavior;
        }

        protected Stream<DELEGATE> activeDelegates() {
            return this.getCustomAnnotationBehavior() == AnnotationBehavior.EXCLUDE ? Stream.of(this.customDelegate) : Stream.of(this.primaryDelegate, this.customDelegate);
        }

        <K, D> Map<K, D> merge(Function<DELEGATE, Map<K, D>> toMap, BiFunction<D, D, D> parallel, Supplier<D> emptyBuilder) {
            Map primaries = toMap.apply(this.primaryDelegate);
            Map customs = toMap.apply(this.customDelegate);
            if (primaries.isEmpty() && customs.isEmpty()) {
                return Collections.emptyMap();
            }
            Function<Object, Object> valueMapper = k -> {
                Object primary = primaries.get(k);
                Object custom = customs.get(k);
                if (custom == null) {
                    if (primary != null) {
                        switch (this.getCustomAnnotationBehavior()) {
                            case INCLUDE: 
                            case ABSTAIN: {
                                return primary;
                            }
                        }
                    }
                    return emptyBuilder.get();
                }
                return parallel.apply(primary, custom);
            };
            return Stream.of(primaries, customs).map(Map::keySet).flatMap(Collection::stream).distinct().collect(Collectors.toMap(Function.identity(), valueMapper));
        }
    }
}

