/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.EntryCacheManager;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryMBeanImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.MetaStoreImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.impl.ReadOnlyManagedLedgerImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerFactoryImpl
implements ManagedLedgerFactory {
    private final MetaStore store;
    private final BookkeeperFactoryForCustomEnsemblePlacementPolicy bookkeeperFactory;
    private final boolean isBookkeeperManaged;
    private final ManagedLedgerFactoryConfig config;
    protected final OrderedScheduler scheduledExecutor;
    private final ExecutorService cacheEvictionExecutor;
    protected final ManagedLedgerFactoryMBeanImpl mbean;
    protected final ConcurrentHashMap<String, CompletableFuture<ManagedLedgerImpl>> ledgers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, PendingInitializeManagedLedger> pendingInitializeLedgers = new ConcurrentHashMap();
    private final EntryCacheManager entryCacheManager;
    private long lastStatTimestamp = System.nanoTime();
    private final ScheduledFuture<?> statsTask;
    private final ScheduledFuture<?> flushCursorsTask;
    private volatile long cacheEvictionTimeThresholdNanos;
    private final MetadataStore metadataStore;
    private volatile boolean closed;
    private boolean metadataServiceAvailable;
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerFactoryImpl.class);

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, ClientConfiguration bkClientConfiguration) throws Exception {
        this(metadataStore, bkClientConfiguration, new ManagedLedgerFactoryConfig());
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, ClientConfiguration bkClientConfiguration, ManagedLedgerFactoryConfig config) throws Exception {
        this(metadataStore, new DefaultBkFactory(bkClientConfiguration), true, config, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookKeeper bookKeeper) throws Exception {
        this(metadataStore, bookKeeper, new ManagedLedgerFactoryConfig());
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookKeeper bookKeeper, ManagedLedgerFactoryConfig config) throws Exception {
        this(metadataStore, (EnsemblePlacementPolicyConfig policyConfig) -> bookKeeper, config);
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookkeeperFactoryForCustomEnsemblePlacementPolicy bookKeeperGroupFactory, ManagedLedgerFactoryConfig config) throws Exception {
        this(metadataStore, bookKeeperGroupFactory, false, config, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookkeeperFactoryForCustomEnsemblePlacementPolicy bookKeeperGroupFactory, ManagedLedgerFactoryConfig config, StatsLogger statsLogger) throws Exception {
        this(metadataStore, bookKeeperGroupFactory, false, config, statsLogger);
    }

    private ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookkeeperFactoryForCustomEnsemblePlacementPolicy bookKeeperGroupFactory, boolean isBookkeeperManaged, ManagedLedgerFactoryConfig config, StatsLogger statsLogger) throws Exception {
        this.scheduledExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(config.getNumManagedLedgerSchedulerThreads()).statsLogger(statsLogger).traceTaskExecution(config.isTraceTaskExecution()).name("bookkeeper-ml-scheduler").build();
        this.cacheEvictionExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("bookkeeper-ml-cache-eviction"));
        this.metadataServiceAvailable = true;
        this.bookkeeperFactory = bookKeeperGroupFactory;
        this.isBookkeeperManaged = isBookkeeperManaged;
        this.metadataStore = metadataStore;
        this.store = new MetaStoreImpl((MetadataStore)metadataStore, (OrderedExecutor)this.scheduledExecutor, config.getManagedLedgerInfoCompressionType());
        this.config = config;
        this.mbean = new ManagedLedgerFactoryMBeanImpl(this);
        this.entryCacheManager = new EntryCacheManager(this);
        this.statsTask = this.scheduledExecutor.scheduleWithFixedDelay(Runnables.catchingAndLoggingThrowables(this::refreshStats), 0L, (long)config.getStatsPeriodSeconds(), TimeUnit.SECONDS);
        this.flushCursorsTask = this.scheduledExecutor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::flushCursors), (long)config.getCursorPositionFlushSeconds(), (long)config.getCursorPositionFlushSeconds(), TimeUnit.SECONDS);
        this.cacheEvictionTimeThresholdNanos = TimeUnit.MILLISECONDS.toNanos(config.getCacheEvictionTimeThresholdMillis());
        this.cacheEvictionExecutor.execute(this::cacheEvictionTask);
        this.closed = false;
        metadataStore.registerSessionListener(this::handleMetadataStoreNotification);
    }

    private synchronized void handleMetadataStoreNotification(SessionEvent e) {
        log.info("Received MetadataStore session event: {}", (Object)e);
        this.metadataServiceAvailable = e.isConnected();
    }

    private synchronized void flushCursors() {
        this.ledgers.values().forEach(mlfuture -> {
            ManagedLedgerImpl ml;
            if (mlfuture.isDone() && !mlfuture.isCompletedExceptionally() && (ml = (ManagedLedgerImpl)mlfuture.getNow(null)) != null) {
                ml.getCursors().forEach(c -> ((ManagedCursorImpl)c).flush());
            }
        });
    }

    private synchronized void refreshStats() {
        long now = System.nanoTime();
        long period = now - this.lastStatTimestamp;
        this.mbean.refreshStats(period, TimeUnit.NANOSECONDS);
        this.ledgers.values().forEach(mlfuture -> {
            ManagedLedgerImpl ml;
            if (mlfuture.isDone() && !mlfuture.isCompletedExceptionally() && (ml = (ManagedLedgerImpl)mlfuture.getNow(null)) != null) {
                ml.mbean.refreshStats(period, TimeUnit.NANOSECONDS);
            }
        });
        this.lastStatTimestamp = now;
    }

    private void cacheEvictionTask() {
        double evictionFrequency = Math.max(Math.min(this.config.getCacheEvictionFrequency(), 1000.0), 0.001);
        long waitTimeMillis = (long)(1000.0 / evictionFrequency);
        while (true) {
            try {
                while (true) {
                    this.doCacheEviction();
                    Thread.sleep(waitTimeMillis);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable t) {
                log.warn("Exception while performing cache eviction: {}", (Object)t.getMessage(), (Object)t);
                continue;
            }
            break;
        }
    }

    private synchronized void doCacheEviction() {
        long maxTimestamp = System.nanoTime() - this.cacheEvictionTimeThresholdNanos;
        this.ledgers.values().forEach(mlfuture -> {
            ManagedLedgerImpl ml;
            if (mlfuture.isDone() && !mlfuture.isCompletedExceptionally() && (ml = (ManagedLedgerImpl)mlfuture.getNow(null)) != null) {
                ml.doCacheEviction(maxTimestamp);
            }
        });
    }

    public Map<String, ManagedLedgerImpl> getManagedLedgers() {
        return Maps.filterValues((Map)Maps.transformValues(this.ledgers, future -> future.getNow(null)), (Predicate)Predicates.notNull());
    }

    @Override
    public ManagedLedger open(String name) throws InterruptedException, ManagedLedgerException {
        return this.open(name, new ManagedLedgerConfig());
    }

    @Override
    public ManagedLedger open(String name, ManagedLedgerConfig config) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedger l = null;
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncOpen(name, config, new AsyncCallbacks.OpenLedgerCallback(){
            {
            }

            @Override
            public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                r.l = ledger;
                latch.countDown();
            }

            @Override
            public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
        return r.l;
    }

    @Override
    public void asyncOpen(String name, AsyncCallbacks.OpenLedgerCallback callback, Object ctx) {
        this.asyncOpen(name, new ManagedLedgerConfig(), callback, null, ctx);
    }

    @Override
    public void asyncOpen(final String name, final ManagedLedgerConfig config, AsyncCallbacks.OpenLedgerCallback callback, Supplier<Boolean> mlOwnershipChecker, Object ctx) {
        if (this.closed) {
            callback.openLedgerFailed(new ManagedLedgerException.ManagedLedgerFactoryClosedException(), ctx);
            return;
        }
        CompletableFuture<ManagedLedgerImpl> existingFuture = this.ledgers.get(name);
        if (existingFuture != null) {
            if (existingFuture.isDone()) {
                try {
                    ManagedLedgerImpl l = existingFuture.get();
                    if (l.getState() == ManagedLedgerImpl.State.Fenced || l.getState() == ManagedLedgerImpl.State.Closed) {
                        log.warn("[{}] Attempted to open ledger in {} state. Removing from the map to recreate it", (Object)name, (Object)l.getState());
                        this.ledgers.remove(name, existingFuture);
                    }
                }
                catch (Exception e) {
                    log.warn("[{}] Got exception while trying to retrieve ledger", (Object)name, (Object)e);
                }
            } else {
                long pendingMs;
                PendingInitializeManagedLedger pendingLedger = this.pendingInitializeLedgers.get(name);
                if (null != pendingLedger && (pendingMs = System.currentTimeMillis() - pendingLedger.createTimeMs) > TimeUnit.SECONDS.toMillis(config.getMetadataOperationsTimeoutSeconds())) {
                    log.warn("[{}] Managed ledger has been pending in initialize state more than {} milliseconds, remove it from cache to retry ...", (Object)name, (Object)pendingMs);
                    this.ledgers.remove(name, existingFuture);
                    this.pendingInitializeLedgers.remove(name, pendingLedger);
                }
            }
        }
        ((CompletableFuture)this.ledgers.computeIfAbsent(name, mlName -> {
            final CompletableFuture future = new CompletableFuture();
            final ManagedLedgerImpl newledger = new ManagedLedgerImpl(this, this.bookkeeperFactory.get(new EnsemblePlacementPolicyConfig(config.getBookKeeperEnsemblePlacementPolicyClassName(), config.getBookKeeperEnsemblePlacementPolicyProperties())), this.store, config, this.scheduledExecutor, name, mlOwnershipChecker);
            final PendingInitializeManagedLedger pendingLedger = new PendingInitializeManagedLedger(newledger);
            this.pendingInitializeLedgers.put(name, pendingLedger);
            newledger.initialize(new ManagedLedgerImpl.ManagedLedgerInitializeLedgerCallback(){

                @Override
                public void initializeComplete() {
                    log.info("[{}] Successfully initialize managed ledger", (Object)name);
                    ManagedLedgerFactoryImpl.this.pendingInitializeLedgers.remove(name, pendingLedger);
                    future.complete(newledger);
                    newledger.maybeUpdateCursorBeforeTrimmingConsumedLedger();
                }

                @Override
                public void initializeFailed(ManagedLedgerException e) {
                    if (config.isCreateIfMissing()) {
                        log.error("[{}] Failed to initialize managed ledger: {}", (Object)name, (Object)e.getMessage());
                    }
                    ManagedLedgerFactoryImpl.this.ledgers.remove(name, future);
                    if (ManagedLedgerFactoryImpl.this.pendingInitializeLedgers.remove(name, pendingLedger)) {
                        pendingLedger.ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

                            @Override
                            public void closeComplete(Object ctx) {
                            }

                            @Override
                            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                                log.warn("[{}] Failed to a pending initialization managed ledger", (Object)name, (Object)exception);
                            }
                        }, null);
                    }
                    future.completeExceptionally(e);
                }
            }, null);
            return future;
        }).thenAccept(ml -> callback.openLedgerComplete((ManagedLedger)ml, ctx))).exceptionally(exception -> {
            callback.openLedgerFailed((ManagedLedgerException)exception.getCause(), ctx);
            return null;
        });
    }

    @Override
    public ReadOnlyCursor openReadOnlyCursor(String managedLedgerName, Position startPosition, ManagedLedgerConfig config) throws InterruptedException, ManagedLedgerException {
        class Result {
            ReadOnlyCursor c = null;
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncOpenReadOnlyCursor(managedLedgerName, startPosition, config, new AsyncCallbacks.OpenReadOnlyCursorCallback(){
            {
            }

            @Override
            public void openReadOnlyCursorComplete(ReadOnlyCursor cursor, Object ctx) {
                r.c = cursor;
                latch.countDown();
            }

            @Override
            public void openReadOnlyCursorFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
        return r.c;
    }

    @Override
    public void asyncOpenReadOnlyCursor(String managedLedgerName, Position startPosition, ManagedLedgerConfig config, AsyncCallbacks.OpenReadOnlyCursorCallback callback, Object ctx) {
        if (this.closed) {
            callback.openReadOnlyCursorFailed(new ManagedLedgerException.ManagedLedgerFactoryClosedException(), ctx);
            return;
        }
        Preconditions.checkArgument((boolean)(startPosition instanceof PositionImpl));
        ReadOnlyManagedLedgerImpl roManagedLedger = new ReadOnlyManagedLedgerImpl(this, this.bookkeeperFactory.get(new EnsemblePlacementPolicyConfig(config.getBookKeeperEnsemblePlacementPolicyClassName(), config.getBookKeeperEnsemblePlacementPolicyProperties())), this.store, config, this.scheduledExecutor, managedLedgerName);
        ((CompletableFuture)roManagedLedger.initializeAndCreateCursor((PositionImpl)startPosition).thenAccept(roCursor -> callback.openReadOnlyCursorComplete((ReadOnlyCursor)roCursor, ctx))).exceptionally(ex -> {
            Throwable t = ex;
            if (t instanceof CompletionException) {
                t = ex.getCause();
            }
            if (t instanceof ManagedLedgerException) {
                callback.openReadOnlyCursorFailed((ManagedLedgerException)t, ctx);
            } else {
                callback.openReadOnlyCursorFailed(new ManagedLedgerException(t), ctx);
            }
            return null;
        });
    }

    void close(ManagedLedger ledger) {
        this.ledgers.remove(ledger.getName());
        this.entryCacheManager.removeEntryCache(ledger.getName());
    }

    @Override
    public CompletableFuture<Void> shutdownAsync() throws ManagedLedgerException {
        if (this.closed) {
            throw new ManagedLedgerException.ManagedLedgerFactoryClosedException();
        }
        this.closed = true;
        this.statsTask.cancel(true);
        this.flushCursorsTask.cancel(true);
        ArrayList ledgerNames = new ArrayList(this.ledgers.keySet());
        ArrayList futures = new ArrayList(ledgerNames.size());
        int numLedgers = ledgerNames.size();
        log.info("Closing {} ledgers", (Object)numLedgers);
        for (String ledgerName : ledgerNames) {
            final CompletableFuture<Object> future = new CompletableFuture<Object>();
            futures.add(future);
            CompletableFuture<ManagedLedgerImpl> ledgerFuture = this.ledgers.remove(ledgerName);
            if (ledgerFuture == null) {
                future.complete(null);
                continue;
            }
            ledgerFuture.whenCompleteAsync((managedLedger, throwable) -> {
                if (throwable != null || managedLedger == null) {
                    future.complete(null);
                    return;
                }
                managedLedger.asyncClose(new AsyncCallbacks.CloseCallback((ManagedLedgerImpl)managedLedger){
                    final /* synthetic */ ManagedLedgerImpl val$managedLedger;
                    {
                        this.val$managedLedger = managedLedgerImpl;
                    }

                    @Override
                    public void closeComplete(Object ctx) {
                        future.complete(null);
                    }

                    @Override
                    public void closeFailed(ManagedLedgerException exception, Object ctx) {
                        log.warn("[{}] Got exception when closing managed ledger: {}", (Object)this.val$managedLedger.getName(), (Object)exception);
                        future.complete(null);
                    }
                }, null);
            }, (Executor)this.scheduledExecutor.chooseThread());
            PendingInitializeManagedLedger pendingLedger = this.pendingInitializeLedgers.get(ledgerName);
            if (pendingLedger == null || ledgerFuture.isDone()) continue;
            ledgerFuture.completeExceptionally(new ManagedLedgerException.ManagedLedgerFactoryClosedException());
        }
        CompletableFuture bookkeeperFuture = new CompletableFuture();
        futures.add(bookkeeperFuture);
        futures.add(CompletableFuture.runAsync(() -> {
            if (this.isBookkeeperManaged) {
                try {
                    BookKeeper bookkeeper = this.bookkeeperFactory.get();
                    if (bookkeeper != null) {
                        bookkeeper.close();
                    }
                    bookkeeperFuture.complete(null);
                }
                catch (Throwable throwable) {
                    bookkeeperFuture.completeExceptionally(throwable);
                }
            } else {
                bookkeeperFuture.complete(null);
            }
            this.scheduledExecutor.shutdown();
            if (!this.ledgers.isEmpty()) {
                log.info("Force closing {} ledgers.", (Object)this.ledgers.size());
                this.ledgers.forEach((ledgerName, ledgerFuture) -> {
                    if (!ledgerFuture.isDone()) {
                        ledgerFuture.completeExceptionally(new ManagedLedgerException.ManagedLedgerFactoryClosedException());
                    } else {
                        ManagedLedgerImpl managedLedger = ledgerFuture.getNow(null);
                        if (managedLedger == null) {
                            return;
                        }
                        try {
                            managedLedger.close();
                        }
                        catch (Throwable throwable) {
                            log.warn("[{}] Got exception when closing managed ledger: {}", (Object)managedLedger.getName(), (Object)throwable);
                        }
                    }
                });
            }
        }));
        this.cacheEvictionExecutor.shutdownNow();
        this.entryCacheManager.clear();
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public void shutdown() throws InterruptedException, ManagedLedgerException {
        if (this.closed) {
            throw new ManagedLedgerException.ManagedLedgerFactoryClosedException();
        }
        this.closed = true;
        this.statsTask.cancel(true);
        this.flushCursorsTask.cancel(true);
        ArrayList<CompletableFuture<ManagedLedgerImpl>> ledgers = new ArrayList<CompletableFuture<ManagedLedgerImpl>>(this.ledgers.values());
        int numLedgers = ledgers.size();
        final CountDownLatch latch = new CountDownLatch(numLedgers);
        log.info("Closing {} ledgers", (Object)numLedgers);
        for (CompletableFuture completableFuture : ledgers) {
            final ManagedLedgerImpl ledger = completableFuture.getNow(null);
            if (ledger == null) {
                latch.countDown();
                continue;
            }
            ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

                @Override
                public void closeComplete(Object ctx) {
                    latch.countDown();
                }

                @Override
                public void closeFailed(ManagedLedgerException exception, Object ctx) {
                    log.warn("[{}] Got exception when closing managed ledger: {}", (Object)ledger.getName(), (Object)exception);
                    latch.countDown();
                }
            }, null);
        }
        latch.await();
        log.info("{} ledgers closed", (Object)numLedgers);
        if (this.isBookkeeperManaged) {
            try {
                BookKeeper bookkeeper = this.bookkeeperFactory.get();
                if (bookkeeper != null) {
                    bookkeeper.close();
                }
            }
            catch (BKException e) {
                throw new ManagedLedgerException(e);
            }
        }
        this.scheduledExecutor.shutdownNow();
        this.cacheEvictionExecutor.shutdownNow();
        this.entryCacheManager.clear();
    }

    @Override
    public CompletableFuture<Boolean> asyncExists(String ledgerName) {
        return this.store.asyncExists(ledgerName);
    }

    @Override
    public ManagedLedgerInfo getManagedLedgerInfo(String name) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerInfo info = null;
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncGetManagedLedgerInfo(name, new AsyncCallbacks.ManagedLedgerInfoCallback(){
            {
            }

            @Override
            public void getInfoComplete(ManagedLedgerInfo info, Object ctx) {
                r.info = info;
                latch.countDown();
            }

            @Override
            public void getInfoFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
        return r.info;
    }

    @Override
    public void asyncGetManagedLedgerInfo(final String name, final AsyncCallbacks.ManagedLedgerInfoCallback callback, final Object ctx) {
        this.store.getManagedLedgerInfo(name, false, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo pbInfo, Stat stat) {
                int i;
                final ManagedLedgerInfo info = new ManagedLedgerInfo();
                info.version = stat.getVersion();
                info.creationDate = DateFormatter.format((long)stat.getCreationTimestamp());
                info.modificationDate = DateFormatter.format((long)stat.getModificationTimestamp());
                info.ledgers = new ArrayList<ManagedLedgerInfo.LedgerInfo>(pbInfo.getLedgerInfoCount());
                if (pbInfo.hasTerminatedPosition()) {
                    info.terminatedPosition = new ManagedLedgerInfo.PositionInfo();
                    info.terminatedPosition.ledgerId = pbInfo.getTerminatedPosition().getLedgerId();
                    info.terminatedPosition.entryId = pbInfo.getTerminatedPosition().getEntryId();
                }
                if (pbInfo.getPropertiesCount() > 0) {
                    info.properties = Maps.newTreeMap();
                    for (i = 0; i < pbInfo.getPropertiesCount(); ++i) {
                        MLDataFormats.KeyValue property = pbInfo.getProperties(i);
                        info.properties.put(property.getKey(), property.getValue());
                    }
                }
                for (i = 0; i < pbInfo.getLedgerInfoCount(); ++i) {
                    MLDataFormats.ManagedLedgerInfo.LedgerInfo pbLedgerInfo = pbInfo.getLedgerInfo(i);
                    ManagedLedgerInfo.LedgerInfo ledgerInfo = new ManagedLedgerInfo.LedgerInfo();
                    ledgerInfo.ledgerId = pbLedgerInfo.getLedgerId();
                    ledgerInfo.entries = pbLedgerInfo.hasEntries() ? Long.valueOf(pbLedgerInfo.getEntries()) : null;
                    ledgerInfo.size = pbLedgerInfo.hasSize() ? Long.valueOf(pbLedgerInfo.getSize()) : null;
                    ledgerInfo.isOffloaded = pbLedgerInfo.hasOffloadContext();
                    info.ledgers.add(ledgerInfo);
                }
                ManagedLedgerFactoryImpl.this.store.getCursors(name, new MetaStore.MetaStoreCallback<List<String>>(){

                    @Override
                    public void operationComplete(List<String> cursorsList, Stat stat) {
                        info.cursors = new ConcurrentSkipListMap<String, ManagedLedgerInfo.CursorInfo>();
                        ArrayList<CompletableFuture<Void>> cursorsFutures = new ArrayList<CompletableFuture<Void>>();
                        for (final String cursorName : cursorsList) {
                            final CompletableFuture cursorFuture = new CompletableFuture();
                            cursorsFutures.add(cursorFuture);
                            ManagedLedgerFactoryImpl.this.store.asyncGetCursorInfo(name, cursorName, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

                                @Override
                                public void operationComplete(MLDataFormats.ManagedCursorInfo pbCursorInfo, Stat stat) {
                                    int i;
                                    ManagedLedgerInfo.CursorInfo cursorInfo = new ManagedLedgerInfo.CursorInfo();
                                    cursorInfo.version = stat.getVersion();
                                    cursorInfo.creationDate = DateFormatter.format((long)stat.getCreationTimestamp());
                                    cursorInfo.modificationDate = DateFormatter.format((long)stat.getModificationTimestamp());
                                    cursorInfo.cursorsLedgerId = pbCursorInfo.getCursorsLedgerId();
                                    if (pbCursorInfo.hasMarkDeleteLedgerId()) {
                                        cursorInfo.markDelete = new ManagedLedgerInfo.PositionInfo();
                                        cursorInfo.markDelete.ledgerId = pbCursorInfo.getMarkDeleteLedgerId();
                                        cursorInfo.markDelete.entryId = pbCursorInfo.getMarkDeleteEntryId();
                                    }
                                    if (pbCursorInfo.getPropertiesCount() > 0) {
                                        cursorInfo.properties = Maps.newTreeMap();
                                        for (i = 0; i < pbCursorInfo.getPropertiesCount(); ++i) {
                                            MLDataFormats.LongProperty property = pbCursorInfo.getProperties(i);
                                            cursorInfo.properties.put(property.getName(), property.getValue());
                                        }
                                    }
                                    if (pbCursorInfo.getIndividualDeletedMessagesCount() > 0) {
                                        cursorInfo.individualDeletedMessages = new ArrayList<ManagedLedgerInfo.MessageRangeInfo>();
                                        for (i = 0; i < pbCursorInfo.getIndividualDeletedMessagesCount(); ++i) {
                                            MLDataFormats.MessageRange range = pbCursorInfo.getIndividualDeletedMessages(i);
                                            ManagedLedgerInfo.MessageRangeInfo rangeInfo = new ManagedLedgerInfo.MessageRangeInfo();
                                            rangeInfo.from.ledgerId = range.getLowerEndpoint().getLedgerId();
                                            rangeInfo.from.entryId = range.getLowerEndpoint().getEntryId();
                                            rangeInfo.to.ledgerId = range.getUpperEndpoint().getLedgerId();
                                            rangeInfo.to.entryId = range.getUpperEndpoint().getEntryId();
                                            cursorInfo.individualDeletedMessages.add(rangeInfo);
                                        }
                                    }
                                    info.cursors.put(cursorName, cursorInfo);
                                    cursorFuture.complete(null);
                                }

                                @Override
                                public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                                    cursorFuture.completeExceptionally(e);
                                }
                            });
                        }
                        ((CompletableFuture)Futures.waitForAll(cursorsFutures).thenRun(() -> callback.getInfoComplete(info, ctx))).exceptionally(ex -> {
                            callback.getInfoFailed(ManagedLedgerException.getManagedLedgerException(ex.getCause()), ctx);
                            return null;
                        });
                    }

                    @Override
                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        callback.getInfoFailed(e, ctx);
                    }
                });
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                callback.getInfoFailed(e, ctx);
            }
        });
    }

    @Override
    public void delete(String name) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncDelete(name, new AsyncCallbacks.DeleteLedgerCallback(){
            {
            }

            @Override
            public void deleteLedgerComplete(Object ctx) {
                latch.countDown();
            }

            @Override
            public void deleteLedgerFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
    }

    @Override
    public void asyncDelete(String name, AsyncCallbacks.DeleteLedgerCallback callback, Object ctx) {
        CompletableFuture<ManagedLedgerImpl> future = this.ledgers.get(name);
        if (future == null) {
            this.deleteManagedLedger(name, callback, ctx);
        } else {
            ((CompletableFuture)future.thenAccept(ml -> ml.asyncDelete(callback, ctx))).exceptionally(ex -> null);
        }
    }

    void deleteManagedLedger(final String managedLedgerName, final AsyncCallbacks.DeleteLedgerCallback callback, Object ctx) {
        this.asyncGetManagedLedgerInfo(managedLedgerName, new AsyncCallbacks.ManagedLedgerInfoCallback(){

            @Override
            public void getInfoComplete(ManagedLedgerInfo info, Object ctx) {
                BookKeeper bkc = ManagedLedgerFactoryImpl.this.getBookKeeper();
                List<CompletableFuture<Void>> futures = info.cursors.entrySet().stream().map(e -> ManagedLedgerFactoryImpl.this.deleteCursor(bkc, managedLedgerName, (String)e.getKey(), (ManagedLedgerInfo.CursorInfo)e.getValue())).collect(Collectors.toList());
                ((CompletableFuture)Futures.waitForAll(futures).thenRun(() -> ManagedLedgerFactoryImpl.this.deleteManagedLedgerData(bkc, managedLedgerName, info, callback, ctx))).exceptionally(ex -> {
                    callback.deleteLedgerFailed(new ManagedLedgerException((Throwable)ex), ctx);
                    return null;
                });
            }

            @Override
            public void getInfoFailed(ManagedLedgerException exception, Object ctx) {
                callback.deleteLedgerFailed(exception, ctx);
            }
        }, ctx);
    }

    private void deleteManagedLedgerData(BookKeeper bkc, String managedLedgerName, ManagedLedgerInfo info, final AsyncCallbacks.DeleteLedgerCallback callback, final Object ctx) {
        ((CompletableFuture)Futures.waitForAll(info.ledgers.stream().filter(li -> !li.isOffloaded).map(li -> bkc.newDeleteLedgerOp().withLedgerId(li.ledgerId).execute()).collect(Collectors.toList())).thenRun(() -> this.store.removeManagedLedger(managedLedgerName, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                callback.deleteLedgerComplete(ctx);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                callback.deleteLedgerFailed(new ManagedLedgerException(e), ctx);
            }
        }))).exceptionally(ex -> {
            callback.deleteLedgerFailed(new ManagedLedgerException((Throwable)ex), ctx);
            return null;
        });
    }

    private CompletableFuture<Void> deleteCursor(BookKeeper bkc, String managedLedgerName, String cursorName, ManagedLedgerInfo.CursorInfo cursor) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletableFuture cursorLedgerDeleteFuture = cursor.cursorsLedgerId != -1L ? bkc.newDeleteLedgerOp().withLedgerId(cursor.cursorsLedgerId).execute() : CompletableFuture.completedFuture(null);
        cursorLedgerDeleteFuture.thenRun(() -> this.store.asyncRemoveCursor(managedLedgerName, cursorName, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                future.complete(null);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                future.completeExceptionally(e);
            }
        }));
        return future;
    }

    public MetaStore getMetaStore() {
        return this.store;
    }

    public ManagedLedgerFactoryConfig getConfig() {
        return this.config;
    }

    @Override
    public EntryCacheManager getEntryCacheManager() {
        return this.entryCacheManager;
    }

    @Override
    public void updateCacheEvictionTimeThreshold(long cacheEvictionTimeThresholdNanos) {
        this.cacheEvictionTimeThresholdNanos = cacheEvictionTimeThresholdNanos;
    }

    @Override
    public long getCacheEvictionTimeThreshold() {
        return this.cacheEvictionTimeThresholdNanos;
    }

    public ManagedLedgerFactoryMXBean getCacheStats() {
        return this.mbean;
    }

    public BookKeeper getBookKeeper() {
        return this.bookkeeperFactory.get();
    }

    public boolean isMetadataServiceAvailable() {
        return this.metadataServiceAvailable;
    }

    public static interface BookkeeperFactoryForCustomEnsemblePlacementPolicy {
        default public BookKeeper get() {
            return this.get(null);
        }

        public BookKeeper get(EnsemblePlacementPolicyConfig var1);
    }

    static class DefaultBkFactory
    implements BookkeeperFactoryForCustomEnsemblePlacementPolicy {
        private final BookKeeper bkClient;

        public DefaultBkFactory(ClientConfiguration bkClientConfiguration) throws InterruptedException, BKException, IOException {
            this.bkClient = new BookKeeper(bkClientConfiguration);
        }

        @Override
        public BookKeeper get(EnsemblePlacementPolicyConfig policy) {
            return this.bkClient;
        }
    }

    private static class PendingInitializeManagedLedger {
        private final ManagedLedgerImpl ledger;
        private final long createTimeMs;

        PendingInitializeManagedLedger(ManagedLedgerImpl ledger) {
            this.ledger = ledger;
            this.createTimeMs = System.currentTimeMillis();
        }
    }
}

