/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import io.prestosql.spi.type.VarcharType;
import java.util.List;

public class VarcharParametricType
implements ParametricType {
    public static final VarcharParametricType VARCHAR = new VarcharParametricType();

    public String getName() {
        return "varchar";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return VarcharType.createUnboundedVarcharType();
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parameter for VARCHAR");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("VARCHAR length must be a number");
        }
        long length = parameter.getLongLiteral();
        if (length == Integer.MAX_VALUE) {
            return VarcharType.createUnboundedVarcharType();
        }
        if (length < 0L || length > 0x7FFFFFFEL) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        return VarcharType.createVarcharType((int)((int)length));
    }
}

