/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import java.io.File;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class JsonWebTokenConfig {
    private String keyFile;
    private String requiredIssuer;
    private String requiredAudience;
    private Optional<String> userMappingPattern = Optional.empty();
    private Optional<File> userMappingFile = Optional.empty();

    @NotNull
    public String getKeyFile() {
        return this.keyFile;
    }

    @Config(value="http-server.authentication.jwt.key-file")
    @LegacyConfig(value={"http.authentication.jwt.key-file"})
    public JsonWebTokenConfig setKeyFile(String keyFile) {
        this.keyFile = keyFile;
        return this;
    }

    public String getRequiredIssuer() {
        return this.requiredIssuer;
    }

    @Config(value="http-server.authentication.jwt.required-issuer")
    @LegacyConfig(value={"http.authentication.jwt.required-issuer"})
    public JsonWebTokenConfig setRequiredIssuer(String requiredIssuer) {
        this.requiredIssuer = requiredIssuer;
        return this;
    }

    public String getRequiredAudience() {
        return this.requiredAudience;
    }

    @Config(value="http-server.authentication.jwt.required-audience")
    @LegacyConfig(value={"http.authentication.jwt.required-audience"})
    public JsonWebTokenConfig setRequiredAudience(String requiredAudience) {
        this.requiredAudience = requiredAudience;
        return this;
    }

    public Optional<String> getUserMappingPattern() {
        return this.userMappingPattern;
    }

    @Config(value="http-server.authentication.jwt.user-mapping.pattern")
    public JsonWebTokenConfig setUserMappingPattern(String userMappingPattern) {
        this.userMappingPattern = Optional.ofNullable(userMappingPattern);
        return this;
    }

    public Optional<File> getUserMappingFile() {
        return this.userMappingFile;
    }

    @Config(value="http-server.authentication.jwt.user-mapping.file")
    public JsonWebTokenConfig setUserMappingFile(File userMappingFile) {
        this.userMappingFile = Optional.ofNullable(userMappingFile);
        return this;
    }
}

