/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.Varchars;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CharacterStringCasts {
    private CharacterStringCasts() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToVarcharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="varchar(x)") Slice slice) {
        if (x > y) {
            return Varchars.truncateToLength((Slice)slice, (int)y.intValue());
        }
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice charToCharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="char(x)") Slice slice) {
        if (x > y) {
            return Varchars.truncateToLength((Slice)slice, (int)y.intValue());
        }
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToCharCast(@LiteralParameter(value="y") Long y, @SqlType(value="varchar(x)") Slice slice) {
        return Chars.truncateToLengthAndTrimSpaces((Slice)slice, (int)y.intValue());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice charToVarcharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="char(x)") Slice slice) {
        if (x.intValue() <= y.intValue()) {
            return Chars.padSpaces((Slice)slice, (int)x.intValue());
        }
        return Chars.padSpaces((Slice)Varchars.truncateToLength((Slice)slice, (int)y.intValue()), (int)y.intValue());
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToCharSaturatedFloorCast(@LiteralParameter(value="y") long y, @SqlType(value="varchar(x)") Slice slice) {
        List<Integer> codePoints = new ArrayList<Integer>(CharacterStringCasts.toCodePoints(slice));
        if ((long)codePoints.size() >= y) {
            codePoints = CharacterStringCasts.trimTrailing(codePoints, 32);
            List codePointsTruncated = (List)codePoints.stream().limit(y).collect(ImmutableList.toImmutableList());
            return CharacterStringCasts.codePointsToSliceUtf8(codePointsTruncated);
        }
        if ((codePoints = CharacterStringCasts.trimTrailing(codePoints, 0)).isEmpty()) {
            return CharacterStringCasts.codePointsToSliceUtf8(Collections.nCopies(Math.toIntExact(y), 0));
        }
        codePoints = new ArrayList<Integer>(codePoints);
        codePoints.set(codePoints.size() - 1, codePoints.get(codePoints.size() - 1) - 1);
        codePoints.addAll(Collections.nCopies(Math.toIntExact(y) - codePoints.size(), 0x10FFFF));
        Verify.verify((codePoints.get(codePoints.size() - 1) != 32 ? 1 : 0) != 0);
        return CharacterStringCasts.codePointsToSliceUtf8(codePoints);
    }

    private static List<Integer> trimTrailing(List<Integer> codePoints, int codePointToTrim) {
        int endIndex;
        for (endIndex = codePoints.size(); endIndex > 0 && codePoints.get(endIndex - 1) == codePointToTrim; --endIndex) {
        }
        return ImmutableList.copyOf(codePoints.subList(0, endIndex));
    }

    private static List<Integer> toCodePoints(Slice slice) {
        ImmutableList.Builder codePoints = ImmutableList.builder();
        for (int offset = 0; offset < slice.length(); offset += SliceUtf8.lengthOfCodePoint((Slice)slice, (int)offset)) {
            int codePoint = SliceUtf8.getCodePointAt((Slice)slice, (int)offset);
            codePoints.add((Object)codePoint);
        }
        return codePoints.build();
    }

    public static Slice codePointsToSliceUtf8(List<Integer> codePoints) {
        int length = codePoints.stream().mapToInt(SliceUtf8::lengthOfCodePoint).sum();
        Slice result = Slices.wrappedBuffer((byte[])new byte[length]);
        int offset = 0;
        for (int codePoint : codePoints) {
            SliceUtf8.setCodePointAt((int)codePoint, (Slice)result, (int)offset);
            offset += SliceUtf8.lengthOfCodePoint((int)codePoint);
        }
        return result;
    }
}

