/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.stats;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.common.stats.JvmGCMetricsLogger;
import org.apache.pulsar.common.stats.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmDefaultGCMetricsLogger
implements JvmGCMetricsLogger {
    private static final Logger log = LoggerFactory.getLogger(JvmDefaultGCMetricsLogger.class);
    private volatile long accumulatedFullGcCount = 0L;
    private volatile long currentFullGcCount = 0L;
    private volatile long accumulatedFullGcTime = 0L;
    private volatile long currentFullGcTime = 0L;
    private static Object runtime;
    private static Method getTotalSafepointTimeHandle;
    private static Method getSafepointCountHandle;
    private Map<String, GCMetrics> gcMetricsMap = new HashMap<String, GCMetrics>();

    static long getTotalSafepointTime() {
        if (getTotalSafepointTimeHandle == null) {
            return -1L;
        }
        return (Long)getTotalSafepointTimeHandle.invoke(runtime, new Object[0]);
    }

    static long getSafepointCount() {
        if (getTotalSafepointTimeHandle == null) {
            return -1L;
        }
        return (Long)getSafepointCountHandle.invoke(runtime, new Object[0]);
    }

    @Override
    public void logMetrics(Metrics metrics) {
        metrics.put("jvm_full_gc_pause", (Object)this.currentFullGcTime);
        metrics.put("jvm_full_gc_count", (Object)this.currentFullGcCount);
        this.gcMetricsMap.forEach((name, metric) -> {
            metrics.put("jvm_" + name + "_gc_pause", (Object)metric.currentGcTime);
            metrics.put("jvm_" + name + "_gc_count", (Object)metric.currentGcCount);
        });
    }

    @Override
    public void refresh() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        try {
            if (gcBeans != null) {
                for (GarbageCollectorMXBean gc : gcBeans) {
                    GCMetrics gcMetric = this.gcMetricsMap.computeIfAbsent(gc.getName(), gcName -> new GCMetrics());
                    long newGcTime = gc.getCollectionTime();
                    long newGcCount = gc.getCollectionCount();
                    gcMetric.currentGcCount = newGcCount - gcMetric.accumulatedGcCount;
                    gcMetric.currentGcTime = newGcTime - gcMetric.accumulatedGcTime;
                    gcMetric.accumulatedGcCount = newGcCount;
                    gcMetric.accumulatedGcTime = newGcTime;
                }
            }
            long newSafePointTime = JvmDefaultGCMetricsLogger.getTotalSafepointTime();
            long newSafePointCount = JvmDefaultGCMetricsLogger.getSafepointCount();
            this.currentFullGcTime = newSafePointTime - this.accumulatedFullGcTime;
            this.currentFullGcCount = newSafePointCount - this.accumulatedFullGcCount;
            this.accumulatedFullGcTime = newSafePointTime;
            this.accumulatedFullGcCount = newSafePointCount;
        }
        catch (Exception e) {
            log.error("Failed to collect GC stats: {}", (Object)e.getMessage());
        }
    }

    static {
        try {
            runtime = Class.forName("sun.management.ManagementFactoryHelper").getMethod("getHotspotRuntimeMBean", new Class[0]).invoke(null, new Object[0]);
            getTotalSafepointTimeHandle = runtime.getClass().getMethod("getTotalSafepointTime", new Class[0]);
            getTotalSafepointTimeHandle.setAccessible(true);
            getSafepointCountHandle = runtime.getClass().getMethod("getSafepointCount", new Class[0]);
            getSafepointCountHandle.setAccessible(true);
            getTotalSafepointTimeHandle.invoke(runtime, new Object[0]);
            getSafepointCountHandle.invoke(runtime, new Object[0]);
        }
        catch (Throwable e) {
            log.warn("Failed to get Runtime bean", e);
        }
    }

    static class GCMetrics {
        volatile long accumulatedGcCount = 0L;
        volatile long currentGcCount = 0L;
        volatile long accumulatedGcTime = 0L;
        volatile long currentGcTime = 0L;

        GCMetrics() {
        }
    }
}

