/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.NestedLoopJoinBridge;
import io.prestosql.operator.NestedLoopJoinPagesBuilder;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

public class NestedLoopBuildOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final NestedLoopJoinBridge nestedLoopJoinBridge;
    private final NestedLoopJoinPagesBuilder nestedLoopJoinPagesBuilder;
    private final LocalMemoryContext localUserMemoryContext;
    private Optional<ListenableFuture<?>> probeDoneWithPages = Optional.empty();

    public NestedLoopBuildOperator(OperatorContext operatorContext, NestedLoopJoinBridge nestedLoopJoinBridge) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.nestedLoopJoinBridge = Objects.requireNonNull(nestedLoopJoinBridge, "nestedLoopJoinBridge is null");
        this.nestedLoopJoinPagesBuilder = new NestedLoopJoinPagesBuilder(operatorContext);
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.probeDoneWithPages.isPresent()) {
            return;
        }
        this.probeDoneWithPages = Optional.of(this.nestedLoopJoinBridge.setPages(this.nestedLoopJoinPagesBuilder.build()));
    }

    @Override
    public boolean isFinished() {
        return this.probeDoneWithPages.map(Future::isDone).orElse(false);
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.probeDoneWithPages.orElse(NOT_BLOCKED);
    }

    @Override
    public boolean needsInput() {
        return !this.probeDoneWithPages.isPresent();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.nestedLoopJoinPagesBuilder.addPage(page);
        if (!this.localUserMemoryContext.trySetBytes(this.nestedLoopJoinPagesBuilder.getEstimatedSize().toBytes())) {
            this.nestedLoopJoinPagesBuilder.compact();
            this.localUserMemoryContext.setBytes(this.nestedLoopJoinPagesBuilder.getEstimatedSize().toBytes());
        }
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class NestedLoopBuildOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager;
        private boolean closed;

        public NestedLoopBuildOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.nestedLoopJoinBridgeManager = Objects.requireNonNull(nestedLoopJoinBridgeManager, "nestedLoopJoinBridgeManager is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, NestedLoopBuildOperator.class.getSimpleName());
            return new NestedLoopBuildOperator(operatorContext, this.nestedLoopJoinBridgeManager.getJoinBridge(driverContext.getLifespan()));
        }

        @Override
        public void noMoreOperators() {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new NestedLoopBuildOperatorFactory(this.operatorId, this.planNodeId, this.nestedLoopJoinBridgeManager);
        }
    }
}

