/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.FieldId;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.util.AstUtils;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

final class ScopeReferenceExtractor {
    private ScopeReferenceExtractor() {
    }

    public static boolean hasReferencesToScope(Node node, Analysis analysis, Scope scope) {
        return ScopeReferenceExtractor.getReferencesToScope(node, analysis, scope).findAny().isPresent();
    }

    public static Stream<Expression> getReferencesToScope(Node node, Analysis analysis, Scope scope) {
        Map<NodeRef<Expression>, FieldId> columnReferences = analysis.getColumnReferenceFields();
        return AstUtils.preOrder((Node)node).filter(Expression.class::isInstance).map(Expression.class::cast).filter(expression -> columnReferences.containsKey(NodeRef.of((Node)expression))).filter(expression -> ScopeReferenceExtractor.isReferenceToScope(expression, scope, columnReferences));
    }

    private static boolean isReferenceToScope(Expression node, Scope scope, Map<NodeRef<Expression>, FieldId> columnReferences) {
        FieldId fieldId = columnReferences.get(NodeRef.of((Node)node));
        Objects.requireNonNull(fieldId, () -> "No FieldId for " + node);
        return ScopeReferenceExtractor.isFieldFromScope(fieldId, scope);
    }

    public static boolean isFieldFromScope(FieldId fieldId, Scope scope) {
        return Objects.equals(fieldId.getRelationId(), scope.getRelationId());
    }
}

