/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.slice.Slice;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.JmxGcMonitor;
import io.airlift.stats.PauseMeter;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.GroupByHashPageIndexerFactory;
import io.prestosql.PagesIndexPageSorter;
import io.prestosql.SystemSessionProperties;
import io.prestosql.block.BlockJsonSerde;
import io.prestosql.client.NodeVersion;
import io.prestosql.client.ServerInfo;
import io.prestosql.connector.ConnectorManager;
import io.prestosql.connector.system.SystemConnectorModule;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.event.SplitMonitor;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.ExplainAnalyzeContext;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.MemoryRevokingScheduler;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.SqlTaskManager;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskManagementExecutor;
import io.prestosql.execution.TaskManager;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.TaskStatus;
import io.prestosql.execution.executor.MultilevelSplitQueue;
import io.prestosql.execution.executor.TaskExecutor;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.execution.scheduler.TopologyAwareNodeSelectorModule;
import io.prestosql.execution.scheduler.UniformNodeSelectorModule;
import io.prestosql.index.IndexManager;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.LocalMemoryManagerExporter;
import io.prestosql.memory.MemoryInfo;
import io.prestosql.memory.MemoryManagerConfig;
import io.prestosql.memory.MemoryPoolAssignmentsRequest;
import io.prestosql.memory.MemoryResource;
import io.prestosql.memory.NodeMemoryConfig;
import io.prestosql.metadata.AnalyzePropertyManager;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.ColumnPropertyManager;
import io.prestosql.metadata.DiscoveryNodeManager;
import io.prestosql.metadata.ForNodeManager;
import io.prestosql.metadata.HandleJsonModule;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.SchemaPropertyManager;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.metadata.StaticCatalogStore;
import io.prestosql.metadata.StaticCatalogStoreConfig;
import io.prestosql.metadata.TablePropertyManager;
import io.prestosql.operator.ExchangeClientConfig;
import io.prestosql.operator.ExchangeClientFactory;
import io.prestosql.operator.ExchangeClientSupplier;
import io.prestosql.operator.ForExchange;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.OperatorStats;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.index.IndexJoinLookupStats;
import io.prestosql.server.AsyncHttpExecutionMBean;
import io.prestosql.server.CoordinatorModule;
import io.prestosql.server.ExchangeExecutionMBean;
import io.prestosql.server.ExpressionSerialization;
import io.prestosql.server.ForAsyncHttp;
import io.prestosql.server.GenerateTraceTokenRequestFilter;
import io.prestosql.server.InternalCommunicationModule;
import io.prestosql.server.NodeStatus;
import io.prestosql.server.PagesResponseWriter;
import io.prestosql.server.PluginManager;
import io.prestosql.server.PluginManagerConfig;
import io.prestosql.server.ServerConfig;
import io.prestosql.server.ServerInfoResource;
import io.prestosql.server.SessionPropertyDefaults;
import io.prestosql.server.SliceSerialization;
import io.prestosql.server.StatusResource;
import io.prestosql.server.TaskExecutorResource;
import io.prestosql.server.TaskResource;
import io.prestosql.server.ThreadResource;
import io.prestosql.server.ThrowableMapper;
import io.prestosql.server.WorkerModule;
import io.prestosql.server.remotetask.HttpLocationFactory;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spiller.FileSingleStreamSpillerFactory;
import io.prestosql.spiller.GenericPartitioningSpillerFactory;
import io.prestosql.spiller.GenericSpillerFactory;
import io.prestosql.spiller.LocalSpillManager;
import io.prestosql.spiller.NodeSpillConfig;
import io.prestosql.spiller.PartitioningSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.spiller.SpillerStats;
import io.prestosql.split.PageSinkManager;
import io.prestosql.split.PageSinkProvider;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.PageSourceProvider;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.SqlEnvironmentConfig;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.gen.JoinFilterFunctionCompiler;
import io.prestosql.sql.gen.OrderingCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.parser.SqlParserOptions;
import io.prestosql.sql.planner.CompilerConfig;
import io.prestosql.sql.planner.LocalExecutionPlanner;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.tree.Expression;
import io.prestosql.transaction.TransactionManagerConfig;
import io.prestosql.type.TypeDeserializer;
import io.prestosql.type.TypeSignatureDeserializer;
import io.prestosql.util.FinalizerService;
import io.prestosql.version.EmbedVersion;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class ServerMainModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ServerConfig serverConfig = (ServerConfig)this.buildConfigObject(ServerConfig.class);
        if (serverConfig.isCoordinator()) {
            this.install((Module)new CoordinatorModule());
        } else {
            this.install(new WorkerModule());
        }
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpServerConfig.class, httpServerConfig -> httpServerConfig.setAdminEnabled(false));
        this.install((Module)new InternalCommunicationModule());
        ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
        binder.bind(SqlParser.class).in(Scopes.SINGLETON);
        SqlParserOptions sqlParserOptions = new SqlParserOptions();
        sqlParserOptions.useEnhancedErrorHandler(serverConfig.isEnhancedErrorReporting());
        binder.bind(SqlParserOptions.class).toInstance((Object)sqlParserOptions);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThrowableMapper.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(SqlEnvironmentConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, ExplainAnalyzeContext.class);
        binder.bind(GcMonitor.class).to(JmxGcMonitor.class).in(Scopes.SINGLETON);
        binder.bind(SessionPropertyManager.class).in(Scopes.SINGLETON);
        binder.bind(SystemSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(SessionPropertyDefaults.class).in(Scopes.SINGLETON);
        binder.bind(SchemaPropertyManager.class).in(Scopes.SINGLETON);
        binder.bind(TablePropertyManager.class).in(Scopes.SINGLETON);
        binder.bind(ColumnPropertyManager.class).in(Scopes.SINGLETON);
        binder.bind(AnalyzePropertyManager.class).in(Scopes.SINGLETON);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("presto");
        binder.bind(DiscoveryNodeManager.class).in(Scopes.SINGLETON);
        binder.bind(InternalNodeManager.class).to(DiscoveryNodeManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DiscoveryNodeManager.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("node-manager", ForNodeManager.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeSchedulerConfig.class);
        binder.bind(NodeScheduler.class).in(Scopes.SINGLETON);
        binder.bind(NodeTaskMap.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NodeScheduler.class).withGeneratedName();
        this.install(ConditionalModule.installModuleIf(NodeSchedulerConfig.class, config -> NodeSchedulerConfig.NodeSchedulerPolicy.UNIFORM == config.getNodeSchedulerPolicy(), (Module)new UniformNodeSelectorModule()));
        this.install(ConditionalModule.installModuleIf(NodeSchedulerConfig.class, config -> NodeSchedulerConfig.NodeSchedulerPolicy.TOPOLOGY == config.getNodeSchedulerPolicy(), (Module)new TopologyAwareNodeSelectorModule()));
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(TaskResource.class);
        ExportBinder.newExporter((Binder)binder).export(TaskResource.class).withGeneratedName();
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(TaskExecutorResource.class);
        ExportBinder.newExporter((Binder)binder).export(TaskExecutorResource.class).withGeneratedName();
        binder.bind(TaskManagementExecutor.class).in(Scopes.SINGLETON);
        binder.bind(SqlTaskManager.class).in(Scopes.SINGLETON);
        binder.bind(TaskManager.class).to(Key.get(SqlTaskManager.class));
        binder.bind(MemoryRevokingScheduler.class).in(Scopes.SINGLETON);
        binder.bind(PauseMeter.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(PauseMeter.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(MemoryManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeMemoryConfig.class);
        binder.bind(LocalMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(LocalMemoryManagerExporter.class).in(Scopes.SINGLETON);
        binder.bind(EmbedVersion.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskManager.class).withGeneratedName();
        binder.bind(TaskExecutor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskExecutor.class).withGeneratedName();
        binder.bind(MultilevelSplitQueue.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(MultilevelSplitQueue.class).withGeneratedName();
        binder.bind(LocalExecutionPlanner.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CompilerConfig.class);
        binder.bind(ExpressionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExpressionCompiler.class).withGeneratedName();
        binder.bind(PageFunctionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(PageFunctionCompiler.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(TaskManagerConfig.class);
        binder.bind(IndexJoinLookupStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IndexJoinLookupStats.class).withGeneratedName();
        binder.bind(AsyncHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(AsyncHttpExecutionMBean.class).withGeneratedName();
        binder.bind(JoinFilterFunctionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(JoinFilterFunctionCompiler.class).withGeneratedName();
        binder.bind(JoinCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(JoinCompiler.class).withGeneratedName();
        binder.bind(OrderingCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(OrderingCompiler.class).withGeneratedName();
        binder.bind(PagesIndex.Factory.class).to(PagesIndex.DefaultFactory.class);
        binder.bind(LookupJoinOperators.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskStatus.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(StageInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(OperatorStats.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ExecutionFailureInfo.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(PagesResponseWriter.class);
        binder.bind(ExchangeClientSupplier.class).to(ExchangeClientFactory.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("exchange", ForExchange.class).withTracing().withFilter(GenerateTraceTokenRequestFilter.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
            config.setMaxContentLength(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        });
        ConfigBinder.configBinder((Binder)binder).bindConfig(ExchangeClientConfig.class);
        binder.bind(ExchangeExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExchangeExecutionMBean.class).withGeneratedName();
        binder.bind(LocationFactory.class).to(HttpLocationFactory.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(MemoryResource.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(MemoryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(MemoryPoolAssignmentsRequest.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TransactionManagerConfig.class);
        binder.bind(PageSourceManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSourceProvider.class).to(PageSourceManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSinkManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSinkProvider.class).to(PageSinkManager.class).in(Scopes.SINGLETON);
        binder.bind(StaticCatalogStore.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticCatalogStoreConfig.class);
        binder.bind(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(Metadata.class).to(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(TypeAnalyzer.class).in(Scopes.SINGLETON);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(TypeSignature.class).to(TypeSignatureDeserializer.class);
        Multibinder.newSetBinder((Binder)binder, Type.class);
        binder.bind(SplitManager.class).in(Scopes.SINGLETON);
        binder.bind(NodePartitioningManager.class).in(Scopes.SINGLETON);
        binder.bind(IndexManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new HandleJsonModule());
        binder.bind(ConnectorManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new SystemConnectorModule());
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Slice.class).to(SliceSerialization.SliceSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Slice.class).to(SliceSerialization.SliceDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Expression.class).to(ExpressionSerialization.ExpressionSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Expression.class).to(ExpressionSerialization.ExpressionDeserializer.class);
        binder.bind(SplitMonitor.class).in(Scopes.SINGLETON);
        NodeVersion nodeVersion = new NodeVersion(serverConfig.getPrestoVersion());
        binder.bind(NodeVersion.class).toInstance((Object)nodeVersion);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto").addProperty("node_version", nodeVersion.toString()).addProperty("coordinator", String.valueOf(serverConfig.isCoordinator()));
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServerInfoResource.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ServerInfo.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(StatusResource.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(NodeStatus.class);
        binder.bind(PluginManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PluginManagerConfig.class);
        binder.bind(CatalogManager.class).in(Scopes.SINGLETON);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Block.class).to(BlockJsonSerde.Serializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Block.class).to(BlockJsonSerde.Deserializer.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThreadResource.class);
        binder.bind(PageSorter.class).to(PagesIndexPageSorter.class).in(Scopes.SINGLETON);
        binder.bind(PageIndexerFactory.class).to(GroupByHashPageIndexerFactory.class).in(Scopes.SINGLETON);
        binder.bind(FinalizerService.class).in(Scopes.SINGLETON);
        binder.bind(SpillerFactory.class).to(GenericSpillerFactory.class).in(Scopes.SINGLETON);
        binder.bind(SingleStreamSpillerFactory.class).to(FileSingleStreamSpillerFactory.class).in(Scopes.SINGLETON);
        binder.bind(PartitioningSpillerFactory.class).to(GenericPartitioningSpillerFactory.class).in(Scopes.SINGLETON);
        binder.bind(SpillerStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SpillerFactory.class).withGeneratedName();
        binder.bind(LocalSpillManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeSpillConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, DispatchManager.class);
        binder.bind(ExecutorCleanup.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForExchange
    public static ScheduledExecutorService createExchangeExecutor(ExchangeClientConfig config) {
        return Executors.newScheduledThreadPool(config.getClientThreads(), Threads.daemonThreadsNamed((String)"exchange-client-%s"));
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static ExecutorService createAsyncHttpResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"async-http-response-%s"));
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static BoundedExecutor createAsyncHttpResponseExecutor(@ForAsyncHttp ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static ScheduledExecutorService createAsyncHttpTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"async-http-timeout-%s"));
    }

    @Provides
    @Singleton
    public static BlockEncodingSerde createBlockEncodingSerde(Metadata metadata) {
        return metadata.getBlockEncodingSerde();
    }

    public static class ExecutorCleanup {
        private final List<ExecutorService> executors;

        @Inject
        public ExecutorCleanup(@ForExchange ScheduledExecutorService exchangeExecutor, @ForAsyncHttp ExecutorService httpResponseExecutor, @ForAsyncHttp ScheduledExecutorService httpTimeoutExecutor) {
            this.executors = ImmutableList.of((Object)exchangeExecutor, (Object)httpResponseExecutor, (Object)httpTimeoutExecutor);
        }

        @PreDestroy
        public void shutdown() {
            this.executors.forEach(ExecutorService::shutdownNow);
        }
    }
}

