/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.ArrayMinMaxUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_max")
@Description(value="Get maximum value of array")
public final class ArrayMaxFunction {
    private ArrayMaxFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Long longArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.longArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Boolean booleanArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.booleanArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Double doubleArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.doubleArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Slice sliceArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.sliceArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Block blockArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Block selectedValue = (Block)elementType.getObject(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Block value = (Block)elementType.getObject(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

