/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Defaults;
import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.util.List;

@ScalarFunction(value="array_distinct")
@Description(value="Remove duplicate values from the given array")
public final class ArrayDistinctFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayDistinctFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block distinct(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"E", "E"}) MethodHandle elementIsDistinctFrom, @SqlType(value="array(E)") Block array) {
        if (array.getPositionCount() < 2) {
            return array;
        }
        if (array.getPositionCount() == 2) {
            boolean distinct;
            boolean firstValueNull = array.isNull(0);
            Object firstValue = firstValueNull ? Defaults.defaultValue((Class)type.getJavaType()) : TypeUtils.readNativeValue((Type)type, (Block)array, (int)0);
            boolean secondValueNull = array.isNull(1);
            Object secondValue = secondValueNull ? Defaults.defaultValue((Class)type.getJavaType()) : TypeUtils.readNativeValue((Type)type, (Block)array, (int)1);
            try {
                distinct = elementIsDistinctFrom.invoke(firstValue, firstValueNull, secondValue, secondValueNull);
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
            if (distinct) {
                return array;
            }
            return array.getSingleValueBlock(0);
        }
        TypedSet typedSet = new TypedSet(type, elementIsDistinctFrom, array.getPositionCount(), "array_distinct");
        int distinctCount = 0;
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder distinctElementBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (typedSet.contains(array, i)) continue;
            typedSet.add(array, i);
            ++distinctCount;
            type.appendTo(array, i, distinctElementBlockBuilder);
        }
        this.pageBuilder.declarePositions(distinctCount);
        return distinctElementBlockBuilder.getRegion(distinctElementBlockBuilder.getPositionCount() - distinctCount, distinctCount);
    }

    @SqlType(value="array(bigint)")
    public Block bigintDistinct(@SqlType(value="array(bigint)") Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        boolean containsNull = false;
        LongOpenHashSet set = new LongOpenHashSet(array.getPositionCount());
        int distinctCount = 0;
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder distinctElementBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) {
                if (containsNull) continue;
                containsNull = true;
                distinctElementBlockBuilder.appendNull();
                ++distinctCount;
                continue;
            }
            long value = BigintType.BIGINT.getLong(array, i);
            if (set.contains(value)) continue;
            set.add(value);
            ++distinctCount;
            BigintType.BIGINT.appendTo(array, i, distinctElementBlockBuilder);
        }
        this.pageBuilder.declarePositions(distinctCount);
        return distinctElementBlockBuilder.getRegion(distinctElementBlockBuilder.getPositionCount() - distinctCount, distinctCount);
    }
}

