/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.arrayagg;

import io.prestosql.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import io.prestosql.operator.aggregation.arrayagg.ArrayAggregationState;
import io.prestosql.operator.aggregation.arrayagg.GroupArrayAggregationState;
import io.prestosql.operator.aggregation.arrayagg.LegacyArrayAggregationGroupState;
import io.prestosql.operator.aggregation.arrayagg.SingleArrayAggregationState;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.type.Type;

public class ArrayAggregationStateFactory
implements AccumulatorStateFactory<ArrayAggregationState> {
    private final Type type;
    private final ArrayAggGroupImplementation mode;

    public ArrayAggregationStateFactory(Type type, ArrayAggGroupImplementation mode) {
        this.type = type;
        this.mode = mode;
    }

    public ArrayAggregationState createSingleState() {
        return new SingleArrayAggregationState(this.type);
    }

    public Class<? extends ArrayAggregationState> getSingleStateClass() {
        return SingleArrayAggregationState.class;
    }

    public ArrayAggregationState createGroupedState() {
        switch (this.mode) {
            case NEW: {
                return new GroupArrayAggregationState(this.type);
            }
            case LEGACY: {
                return new LegacyArrayAggregationGroupState(this.type);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.mode}));
    }

    public Class<? extends ArrayAggregationState> getGroupedStateClass() {
        switch (this.mode) {
            case NEW: {
                return GroupArrayAggregationState.class;
            }
            case LEGACY: {
                return LegacyArrayAggregationGroupState.class;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.mode}));
    }
}

