/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.dispatcher;

import io.prestosql.Session;
import io.prestosql.dispatcher.DispatchExecutor;
import io.prestosql.dispatcher.FailedDispatchQuery;
import io.prestosql.event.QueryMonitor;
import io.prestosql.execution.LocationFactory;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.util.Failures;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

public class FailedDispatchQueryFactory {
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final ExecutorService executor;

    @Inject
    public FailedDispatchQueryFactory(QueryMonitor queryMonitor, LocationFactory locationFactory, DispatchExecutor dispatchExecutor) {
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executor = Objects.requireNonNull(dispatchExecutor, "dispatchExecutor is null").getExecutor();
    }

    public FailedDispatchQuery createFailedDispatchQuery(Session session, String query, Optional<String> preparedQuery, Optional<ResourceGroupId> resourceGroup, Throwable throwable) {
        FailedDispatchQuery failedDispatchQuery = new FailedDispatchQuery(session, query, preparedQuery, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, throwable, this.executor);
        BasicQueryInfo queryInfo = failedDispatchQuery.getBasicQueryInfo();
        this.queryMonitor.queryCreatedEvent(queryInfo);
        this.queryMonitor.queryImmediateFailureEvent(queryInfo, Failures.toFailure(throwable));
        return failedDispatchQuery;
    }
}

