/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.event.ExecutionCompletedEvent;
import net.jodah.failsafe.function.CheckedConsumer;

public interface EventListener {
    public void handle(Object var1, Throwable var2, ExecutionContext var3);

    public static <R> EventListener of(CheckedConsumer<? extends ExecutionCompletedEvent<R>> handler) {
        return (result, failure, context) -> {
            try {
                handler.accept(new ExecutionCompletedEvent<Object>(result, failure, context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    public static <R> EventListener ofAttempt(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> handler) {
        return (result, failure, context) -> {
            try {
                handler.accept(new ExecutionAttemptedEvent<Object>(result, failure, context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    default public void handle(ExecutionResult result, ExecutionContext context) {
        this.handle(result.getResult(), result.getFailure(), context);
    }
}

