/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.NodeSelector;
import io.prestosql.metadata.InternalNode;
import io.prestosql.operator.BucketPartitionFunction;
import io.prestosql.operator.HashGenerator;
import io.prestosql.operator.InterpretedHashGenerator;
import io.prestosql.operator.PartitionFunction;
import io.prestosql.operator.PrecomputedHashGenerator;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.BucketFunction;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.NodePartitionMap;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.util.Failures;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SystemPartitioningHandle
implements ConnectorPartitioningHandle {
    public static final PartitioningHandle SINGLE_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.SINGLE, SystemPartitionFunction.SINGLE);
    public static final PartitioningHandle COORDINATOR_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.COORDINATOR_ONLY, SystemPartitionFunction.SINGLE);
    public static final PartitioningHandle FIXED_HASH_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.HASH);
    public static final PartitioningHandle FIXED_ARBITRARY_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.ROUND_ROBIN);
    public static final PartitioningHandle FIXED_BROADCAST_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.BROADCAST);
    public static final PartitioningHandle SCALED_WRITER_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.SCALED, SystemPartitionFunction.ROUND_ROBIN);
    public static final PartitioningHandle SOURCE_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.SOURCE, SystemPartitionFunction.UNKNOWN);
    public static final PartitioningHandle ARBITRARY_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.ARBITRARY, SystemPartitionFunction.UNKNOWN);
    public static final PartitioningHandle FIXED_PASSTHROUGH_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.UNKNOWN);
    private final SystemPartitioning partitioning;
    private final SystemPartitionFunction function;

    private static PartitioningHandle createSystemPartitioning(SystemPartitioning partitioning, SystemPartitionFunction function) {
        return new PartitioningHandle(Optional.empty(), Optional.empty(), new SystemPartitioningHandle(partitioning, function));
    }

    @JsonCreator
    public SystemPartitioningHandle(@JsonProperty(value="partitioning") SystemPartitioning partitioning, @JsonProperty(value="function") SystemPartitionFunction function) {
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.function = Objects.requireNonNull(function, "function is null");
    }

    @JsonProperty
    public SystemPartitioning getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public SystemPartitionFunction getFunction() {
        return this.function;
    }

    public boolean isSingleNode() {
        return this.partitioning == SystemPartitioning.COORDINATOR_ONLY || this.partitioning == SystemPartitioning.SINGLE;
    }

    public boolean isCoordinatorOnly() {
        return this.partitioning == SystemPartitioning.COORDINATOR_ONLY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemPartitioningHandle that = (SystemPartitioningHandle)o;
        return this.partitioning == that.partitioning && this.function == that.function;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitioning, this.function});
    }

    public String toString() {
        if (this.partitioning == SystemPartitioning.FIXED) {
            return this.function.toString();
        }
        return this.partitioning.toString();
    }

    public NodePartitionMap getNodePartitionMap(Session session, NodeScheduler nodeScheduler) {
        Object nodes;
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(Optional.empty());
        if (this.partitioning == SystemPartitioning.COORDINATOR_ONLY) {
            nodes = ImmutableList.of((Object)nodeSelector.selectCurrentNode());
        } else if (this.partitioning == SystemPartitioning.SINGLE) {
            nodes = nodeSelector.selectRandomNodes(1);
        } else if (this.partitioning == SystemPartitioning.FIXED) {
            nodes = nodeSelector.selectRandomNodes(SystemSessionProperties.getHashPartitionCount(session));
        } else {
            throw new IllegalArgumentException("Unsupported plan distribution " + (Object)((Object)this.partitioning));
        }
        Failures.checkCondition(!nodes.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
        return new NodePartitionMap((List<InternalNode>)nodes, split -> {
            throw new UnsupportedOperationException("System distribution does not support source splits");
        });
    }

    public PartitionFunction getPartitionFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int[] bucketToPartition) {
        Objects.requireNonNull(partitionChannelTypes, "partitionChannelTypes is null");
        Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
        BucketFunction bucketFunction = this.function.createBucketFunction(partitionChannelTypes, isHashPrecomputed, bucketToPartition.length);
        return new BucketPartitionFunction(bucketFunction, bucketToPartition);
    }

    public static enum SystemPartitionFunction {
        SINGLE{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount) {
                Preconditions.checkArgument((bucketCount == 1 ? 1 : 0) != 0, (Object)"Single partition can only have one bucket");
                return new SingleBucketFunction();
            }
        }
        ,
        HASH{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount) {
                if (isHashPrecomputed) {
                    return new HashBucketFunction(new PrecomputedHashGenerator(0), bucketCount);
                }
                int[] hashChannels = new int[partitionChannelTypes.size()];
                for (int i = 0; i < partitionChannelTypes.size(); ++i) {
                    hashChannels[i] = i;
                }
                return new HashBucketFunction(new InterpretedHashGenerator(partitionChannelTypes, hashChannels), bucketCount);
            }
        }
        ,
        ROUND_ROBIN{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount) {
                return new RoundRobinBucketFunction(bucketCount);
            }
        }
        ,
        BROADCAST{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        UNKNOWN{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount) {
                throw new UnsupportedOperationException();
            }
        };


        public abstract BucketFunction createBucketFunction(List<Type> var1, boolean var2, int var3);

        private static class HashBucketFunction
        implements BucketFunction {
            private final HashGenerator generator;
            private final int bucketCount;

            public HashBucketFunction(HashGenerator generator, int bucketCount) {
                Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"partitionCount must be at least 1");
                this.generator = generator;
                this.bucketCount = bucketCount;
            }

            public int getBucket(Page page, int position) {
                return this.generator.getPartition(this.bucketCount, position, page);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("generator", (Object)this.generator).add("bucketCount", this.bucketCount).toString();
            }
        }

        private static class RoundRobinBucketFunction
        implements BucketFunction {
            private final int bucketCount;
            private int counter;

            public RoundRobinBucketFunction(int bucketCount) {
                Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be at least 1");
                this.bucketCount = bucketCount;
            }

            public int getBucket(Page page, int position) {
                int bucket = this.counter % this.bucketCount;
                this.counter = this.counter + 1 & Integer.MAX_VALUE;
                return bucket;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("bucketCount", this.bucketCount).toString();
            }
        }

        private static class SingleBucketFunction
        implements BucketFunction {
            private SingleBucketFunction() {
            }

            public int getBucket(Page page, int position) {
                return 0;
            }
        }
    }

    private static enum SystemPartitioning {
        SINGLE,
        FIXED,
        SOURCE,
        SCALED,
        COORDINATOR_ONLY,
        ARBITRARY;

    }
}

