/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;

public final class ZipFunction
extends SqlScalarFunction {
    public static final int MIN_ARITY = 2;
    public static final int MAX_ARITY = 5;
    public static final ZipFunction[] ZIP_FUNCTIONS;
    private static final MethodHandle METHOD_HANDLE;
    private final List<String> typeParameters;

    private ZipFunction(int arity) {
        this((List)IntStream.rangeClosed(1, arity).mapToObj(s -> "T" + s).collect(ImmutableList.toImmutableList()));
    }

    private ZipFunction(List<String> typeParameters) {
        super(new FunctionMetadata(new Signature("zip", (List)typeParameters.stream().map(Signature::typeVariable).collect(ImmutableList.toImmutableList()), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)TypeSignature.rowType((List)((List)typeParameters.stream().map(x$0 -> new TypeSignature(x$0, new TypeSignatureParameter[0])).map(TypeSignatureParameter::anonymousField).collect(ImmutableList.toImmutableList())))), (List)typeParameters.stream().map(name -> TypeSignature.arrayType((TypeSignature)new TypeSignature(name, new TypeSignatureParameter[0]))).collect(ImmutableList.toImmutableList()), false), false, Collections.nCopies(typeParameters.size(), new FunctionArgumentDefinition(false)), false, true, "Merges the given arrays, element-wise, into a single array of rows.", FunctionKind.SCALAR));
        this.typeParameters = typeParameters;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        List types = (List)this.typeParameters.stream().map(boundVariables::getTypeVariable).collect(ImmutableList.toImmutableList());
        List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties = Collections.nCopies(types.size(), ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
        List<Class<?>> javaArgumentTypes = Collections.nCopies(types.size(), Block.class);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(types).asVarargsCollector(Block[].class).asType(MethodType.methodType(Block.class, javaArgumentTypes));
        return new ScalarFunctionImplementation(false, argumentProperties, methodHandle);
    }

    @UsedByGeneratedCode
    public static Block zip(List<Type> types, Block ... arrays) {
        int biggestCardinality = 0;
        for (Block array : arrays) {
            biggestCardinality = Math.max(biggestCardinality, array.getPositionCount());
        }
        RowType rowType = RowType.anonymous(types);
        BlockBuilder outputBuilder = rowType.createBlockBuilder(null, biggestCardinality);
        for (int outputPosition = 0; outputPosition < biggestCardinality; ++outputPosition) {
            BlockBuilder rowBuilder = outputBuilder.beginBlockEntry();
            for (int fieldIndex = 0; fieldIndex < arrays.length; ++fieldIndex) {
                if (arrays[fieldIndex].getPositionCount() <= outputPosition) {
                    rowBuilder.appendNull();
                    continue;
                }
                types.get(fieldIndex).appendTo(arrays[fieldIndex], outputPosition, rowBuilder);
            }
            outputBuilder.closeEntry();
        }
        return outputBuilder.build();
    }

    static {
        METHOD_HANDLE = Reflection.methodHandle(ZipFunction.class, "zip", List.class, Block[].class);
        ZIP_FUNCTIONS = new ZipFunction[4];
        for (int arity = 2; arity <= 5; ++arity) {
            ZipFunction.ZIP_FUNCTIONS[arity - 2] = new ZipFunction(arity);
        }
    }
}

